#!/bin/bash

# JMC Executable Generator for Linux
# Script has been tested for Fedora-type Linux systems.
# Assumes jacket at /usr/local/jacket/engine by default

# MUST be run from the directory that contains all MATLAB scripts that form the application
# Application should NOT contain addpath statements.


if [ $# -ge 3 -o $# -lt 1 ]
then
    echo USAGE: ./generate_jmc_executable.sh MAIN_MATLAB_FILE [path_to_engine];
    exit;
fi

ENGINE_PATH=/usr/local/jacket/engine;
if [ $# -eq 2 ] 
then
    ENGINE_PATH=$2;
fi
CUDA_PATH=$ENGINE_PATH/cuda;
MAIN_MATLAB_FILE=$1;
APPNAME=${MAIN_MATLAB_FILE%.m};

# Evaluate arguments

[ ! -f `pwd`/$1 ] && echo Cannot find MATLAB script $1 in `pwd` && exit;
[ ! -d $ENGINE_PATH ] && echo Cannot find Jacket installation at $ENGINE_PATH && exit;
[ ! -d $CUDA_PATH ] && echo Cannot find CUDA package at $CUDA_PATH && exit;

# Check if executable package can be made.

ARCH=`uname -m`;
echo $APPNAME;
pkg=${APPNAME}_${ARCH};
echo Target ... $pkg;
mkdir $pkg;
[ $? -ne 0 ] && echo Unable to create package to distribute. Aborting && exit;

# Generate executable
echo Using Engine .. $ENGINE_PATH
echo Using CUDA .... $CUDA_PATH
mcc -a $ENGINE_PATH -m $MAIN_MATLAB_FILE
[ $? -ne 0 ] && echo Error While Compiling. Aborting. && rmdir $pkg && exit;

# Prepare Distribution package

mv run_$APPNAME.sh $pkg;
mv $APPNAME $pkg;
mv readme.txt $pkg;

cd $pkg;

# Make shared libraries accessible.

if [ $ARCH = 'i686' ]
then
    [ !  -f libcublas.so.2 ] && cp $CUDA_PATH/lib/libcublas.so.2.3 .
    ln -s libcublas.so.2.3 libcublas.so.2;
    [ !  -f libcudart.so.2 ] && cp $CUDA_PATH/lib/libcudart.so.2.3 .
    ln -s libcudart.so.2.3 libcudart.so.2;
    [ !  -f libcufft.so.2 ] && cp $CUDA_PATH/lib/libcufft.so.2.3 libcufft.so.2.3
    ln -s libcufft.so.2.3 libcufft.so.2;
    [ ! -f libjacket.so ] && cp $CUDA_PATH/lib/libjacket.so libjacket.so;
    [ ! -f libboost_thread-mt.so.3 ] && cp $CUDA_PATH/lib/libboost_thread-mt.so.3 libboost_thread-mt.so.3;

else

    [ !  -f libcublas.so.2 ] && cp $CUDA_PATH/lib64/libcublas.so.2.3 .
    ln -s libcublas.so.2.3 libcublas.so.2;
    [ !  -f libcudart.so.2 ] && cp $CUDA_PATH/lib64/libcudart.so.2.3 .
    ln -s libcudart.so.2.3 libcudart.so.2;
    [ !  -f libcufft.so.2 ] && cp $CUDA_PATH/lib64/libcufft.so.2.3 libcufft.so.2.3
    ln -s libcufft.so.2.3 libcufft.so.2;
    [ ! -f libjacket64.so ] && cp $CUDA_PATH/lib64/libjacket64.so libjacket64.so;
    [ ! -f libboost_thread-mt.so.3 ] && cp $CUDA_PATH/lib64/libboost_thread-mt.so.3 libboost_thread-mt.so.3;

fi

echo Executable Package generated at `pwd`/$pkg;
cd ..

# clean_up
rm *.c *.prj *.log;
