close all

figure(1); clf(1); hold on;
ofname = 'fermi_gflops_double_cublas_01';
nfname = 'fermi_gflops_double_jacket_01';

load(ofname);
old = GFlops_cpu;
load(nfname);
new = GFlops_gpu;

szlim = 2500;
sz = size(new,1);
sz = [10:9+sz];
sz = sz(1:szlim);
old = old(1:szlim);
new = new(1:szlim);
plot(sz,old,'-b')    
plot(sz,new,'-r')    
grid;

titlex = sprintf('DGEMM : Matrix Size, NxN   [-]');
xlabel(titlex);
ylabel('Performance   [GFlops]');
legend({'CUBLAS', 'Jacket 1.4'}, 'Location', 'best');



