<?php
/**
 * Internationalisation file for extension intersection.
 * Old version of DynamicPageList extension used for Wikinews projects
 *
 * @addtogroup Extensions
*/

$messages= array();

$messages['en'] = array(
	'intersection-desc'          => 'Outputs a bulleted list of the most recent items residing in a category, or a union of several categories',
	'intersection_toomanycats'   => 'DynamicPageList: Too many categories!',
	'intersection_toofewcats'    => 'DynamicPageList: Too few categories!',
	'intersection_noresults'     => 'DynamicPageList: No results!',
	'intersection_noincludecats' => 'DynamicPageList: You need to include at least one category, or specify a namespace!',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'intersection-desc'          => "Preduz una lista d'os elementos más rezients que bi ha en una categoría u a unión de barios categorías",
	'intersection_toomanycats'   => 'DynamicPageList: Masiadas categorías!',
	'intersection_toofewcats'    => 'DynamicPageList: numero insufizient de categorías!',
	'intersection_noresults'     => 'DynamicPageList: No bi ha garra resultau!',
	'intersection_noincludecats' => "DynamicPageList: Ha d'encluyir á lo menos una categoría u endicar un espazio de nombres!",
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'intersection-desc'          => 'يخرج قائمة معلمة بأحدث المدخلات الساكنة في تصنيف، أو اتحاد عدة تصنيفات',
	'intersection_toomanycats'   => 'قائمة صفحة ديناميكية: تصنيفات كثيرة جدا!',
	'intersection_toofewcats'    => 'قائمة صفحة ديناميكية: تصنيفات قليلة جدا!',
	'intersection_noresults'     => 'قائمة صفحة ديناميكية: لا نتائج!',
	'intersection_noincludecats' => 'قائمة صفحة ديناميكية: ينبغي أن تضمن تصنيفا واحدا على الأقل، أو تحدد نطاقا!',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: ¡Demasiaes categoríes!',
	'intersection_toofewcats'    => 'DynamicPageList: ¡Demasiaes poques categoríes!',
	'intersection_noresults'     => 'DynamicPageList: ¡Nun hai resultaos!',
	'intersection_noincludecats' => 'DynamicPageList: ¡Necesites amiestar a lo menos una categoría, o especificar un espaciu de nomes!',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Твърде много категории!',
	'intersection_toofewcats'    => 'DynamicPageList: Твърде малко категории!',
	'intersection_noresults'     => 'DynamicPageList: Няма резултати!',
	'intersection_noincludecats' => 'DynamicPageList: Необходимо е да се включи поне една категория или да се посочи именно пространство!',
);

/** Bengali (বাংলা)
 * @author Bellayet
 */
$messages['bn'] = array(
	'intersection_toomanycats' => 'DynamicPageList: অনেক বেশি বিষয়শ্রেণী!',
	'intersection_toofewcats'  => 'DynamicPageList: অনেক কম বিষয়শ্রেণী!',
	'intersection_noresults'   => 'DynamicPageList: ফলাফল নাই!',
);

/** Czech (Česky)
 * @author Li-sung
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'intersection-desc'          => 'Vypíše seznam nejnovějších položek v kategorii nebo sjednotí několik kategorií',
	'intersection_toomanycats'   => 'DynamicPageList: Příliš mnoho kategorií!',
	'intersection_toofewcats'    => 'DynamicPageList: Málo kategorií!',
	'intersection_noresults'     => 'DynamicPageList: Žádné výsledky!',
	'intersection_noincludecats' => 'DynamicPageList: Musíte zahrnout alespoň jednu kategorii nebo určit jmenný prostor!',
);

/** German (Deutsch)
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'intersection-desc'          => 'Ausgabe einer Liste der aktuellsten Einträge in einer Kategorie, oder der Schnittmenge mehrerer Kategorien',
	'intersection_toomanycats'   => 'DynamicPageList: Zuviele Kategorien!',
	'intersection_toofewcats'    => 'DynamicPageList: Zuwenige Kategorien!',
	'intersection_noresults'     => 'DynamicPageList: Kein Ergebnis!',
	'intersection_noincludecats' => 'DynamicPageList: Es muss mindestens eine Kategorie eingebunden werden oder gebe einen Namensraum an!',
);

/** فارسی (فارسی)
 * @author Huji
 */
$messages['fa'] = array(
	'intersection-desc'          => 'فهرست گلوله‌ای از صفحه‌هایی به نمایش در می‌آورد که به تازگی در یک یا چند رده وارد شده‌اند',
	'intersection_toomanycats'   => 'DynamicPageList: تعداد رده‌ها زیاد است!',
	'intersection_toofewcats'    => 'DynamicPageList: تعداد رده‌ها کم است!',
	'intersection_noresults'     => 'DynamicPageList: نتیجه‌ای وجود ندارد!',
	'intersection_noincludecats' => 'DynamicPageList: شما حداقل باید یک رده را وارد کنید، یا یک فضای نام را مشخص کنید!',

);

/** Finnish (Suomi)
 * @author Nike
 */
$messages['fi'] = array(
	'intersection_toomanycats' => 'DynamicPageList: Liian monta luokkaa.',
	'intersection_toofewcats'  => 'DynamicPageList: Liian vähän luokkia.',
	'intersection_noresults'   => 'DynamicPageList: Ei tuloksia.',
);

/** French (Français)
 * @author Grondin
 * @author Urhixidur
 */
$messages['fr'] = array(
	'intersection-desc'          => 'Affiche une liste, à puces, des articles les plus récents dans une catégorie, ou à partir d’une combinaison de plusieurs catégories.',
	'intersection_toomanycats'   => 'DynamicPageList : Trop de catégories !',
	'intersection_toofewcats'    => 'DynamicPageList : Pas assez de catégories !',
	'intersection_noresults'     => 'DynamicPageList : Aucun résultat !',
	'intersection_noincludecats' => 'DynamicPageList : vous devez inclure au moins une catégorie, ou préciser un nom d’espace !',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'intersection-desc'          => 'Afiche una lista de puges des articllos los ples novéls dens una catègorie, ou ben dês una combinèson de plusiors catègories.',
	'intersection_toomanycats'   => 'DynamicPageList : trop de catègories !',
	'intersection_toofewcats'    => 'DynamicPageList : pas prod de catègories !',
	'intersection_noresults'     => 'DynamicPageList : nion rèsultat !',
	'intersection_noincludecats' => 'DynamicPageList : vos avéd fôta d’encllure u muens yona catègorie, ou ben de spècefiar un èspâço de nom !',
);

$messages['gl'] = array(
	'intersection_toomanycats' => 'DynamicPageList: Demasiadas categorías!',
	'intersection_toofewcats' => 'DynamicPageList: Demasiado poucas categorías!',
	'intersection_noresults' => 'DynamicPageList: Ningún resultado!',
	'intersection_noincludecats' => 'DynamicPageList: Ten que incluír unha categoría polo menos ou especificar un espazo de nomes!',
);

/** Croatian (Hrvatski)
 * @author Dnik
 */
$messages['hr'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Previše kategorija!',
	'intersection_toofewcats'    => 'DynamicPageList: Premalo kategorija!',
	'intersection_noresults'     => 'DynamicPageList: Nema rezultata!',
	'intersection_noincludecats' => 'DynamicPageList: Morate uključiti bar jednu kategoriju, ili odabrati imenski prostor!',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'intersection-desc'          => 'Wudaće lisćiny najaktualnišich zapiskow w jednej kategoriji abo w skupinje kategorijow',
	'intersection_toomanycats'   => 'DynamicPageList: Přewjele kategorijow!',
	'intersection_toofewcats'    => 'DynamicPageList: Přemało kategorijow!',
	'intersection_noresults'     => 'DynamicPageList: Žane wuslědki!',
	'intersection_noincludecats' => 'DynamicPageList: Dyrbiš znajmjeńša kednu kategoriju zapřijeć abo mjenowy rum podać!',
);

/** Hungarian (Magyar)
 * @author KossuthRad
 */
$messages['hu'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Túl sok kategória!',
	'intersection_toofewcats'    => 'DynamicPageList: Túl kevés kategória!',
	'intersection_noresults'     => 'DynamicPageList: Nincs eredmény!',
	'intersection_noincludecats' => 'DynamicPageList: Tartalmaznod kell legalább egy kategóriát különösképpen a névtérre!',
);

/** Italian (Italiano)
 * @author BrokenArrow
 */
$messages['it'] = array(
	'intersection-desc'          => "Visualizza un elenco puntato con gli elementi più recenti inseriti in una categoria o nell'unione di più categorie",
	'intersection_toomanycats'   => 'DynamicPageList: Numero di categorie eccessivo.',
	'intersection_toofewcats'    => 'DynamicPageList: Numero di categorie insufficiente.',
	'intersection_noresults'     => 'DynamicPageList: Nessun risultato.',
	'intersection_noincludecats' => 'DynamicPageList: È necessario includere almeno una categoria oppure specificare un namespace.',
);

/** Japanese (日本語)
 * @author JtFuruhata
 */
$messages['ja'] = array(
	'intersection-desc'          => '単一カテゴリ内または複数カテゴリ内において最近更新された項目を箇条書きで表示する',
	'intersection_toomanycats'   => 'DynamicPageList: カテゴリ指定が多すぎます！',
	'intersection_toofewcats'    => 'DynamicPageList: カテゴリ指定が少なすぎます！',
	'intersection_noresults'     => 'DynamicPageList: 最近更新された項目はありません！',
	'intersection_noincludecats' => 'DynamicPageList: 1つ以上のカテゴリ、または名前空間を指定する必要があります！',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'intersection_noresults' => 'Dynamesch Säite-Lëscht: Kee Resultat!',
);

/** Limburgish (Limburgs)
 * @author Matthias
 */
$messages['li'] = array(
	'intersection-desc'          => 'Geeft als uitvoer een ongenummerde lijst met de meest recent toegevoegde items in een categorie, of een combinatie van categorieë',
	'intersection_toomanycats'   => 'DynamicPageList: Te veel categorieë!',
	'intersection_toofewcats'    => 'DynamicPageList: Te weinig categorieë!',
	'intersection_noresults'     => 'DynamicPageList: Gein resultate!',
	'intersection_noincludecats' => 'DynamicPageList: U moet tenminste een categorie of een naamruimte opgeve!',
);

/** Lithuanian (Lietuvių)
 * @author Matasg
 */
$messages['lt'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Per daug kategorijų!',
	'intersection_toofewcats'    => 'DynamicPageList: Per mažai kategorijų!',
	'intersection_noresults'     => 'DynamicPageList: Nėra rezultatų!',
	'intersection_noincludecats' => 'DynamicPageList: Jums reikia įtraukti bent vieną kategoriją, arba nurodyti vardų sritį!',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'intersection-desc'          => 'Geeft als uitvoer een ongenummerde lijst met de meest recent toegevoegde items in een categorie, of een combinatie van categorieën',
	'intersection_toomanycats'   => 'DynamicPageList: Te veel categorieën!',
	'intersection_toofewcats'    => 'DynamicPageList: Te weinig categorieën!',
	'intersection_noresults'     => 'DynamicPageList: Geen resultaten!',
	'intersection_noincludecats' => 'DynamicPageList: U moet tenminste een categorie of een naamruimte opgeven!',
);

/** Norwegian (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'intersection-desc'          => 'Gir en punktliste over de nyeste elementene i en kategori, eller elementer som er felles i flere kategorier',
	'intersection_toomanycats'   => 'Dynamisk sideliste: For mange kategorier!',
	'intersection_toofewcats'    => 'Dynamisk sidelist: For få kategorier!',
	'intersection_noresults'     => 'Dynamisk sideliste: Ingen resultater!',
	'intersection_noincludecats' => 'Dynamisk sideliste: Du må inkludere minst én kategori, eller oppgi et navnerom!',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'intersection-desc'          => 'Aficha una lista, amb de piuses, dels articles mai recents dins una categoria, o a partir d’una combinason de mantuna categoria.',
	'intersection_toomanycats'   => 'DynamicPageList : Tròp de categorias !',
	'intersection_toofewcats'    => 'DynamicPageList : Pas pro de categorias !',
	'intersection_noresults'     => 'DynamicPageList : Pas cap de resultat !',
	'intersection_noincludecats' => 'DynamicPageList : avètz besonh d’inclòure al mens una categoria, o de precisar un nom d’espaci !',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Zbyt wiele kategorii!',
	'intersection_toofewcats'    => 'DynamicPageList: Zbyt mało kategorii!',
	'intersection_noresults'     => 'DynamicPageList: Brak wyników!',
	'intersection_noincludecats' => 'DynamicPageList: Musisz załączyć co najmniej jedną kategorię lub określić przestrzeń nazw!',
);

/** Portuguese (Português)
 * @author 555
 * @author Malafaya
 */
$messages['pt'] = array(
	'intersection-desc'          => 'constrói uma lista pontuada dos itens mais recentes presentes numa categoria, ou uma união de várias categorias',
	'intersection_toomanycats'   => 'DynamicPageList: Categorias em excesso!',
	'intersection_toofewcats'    => 'DynamicPageList: Poucas categorias!',
	'intersection_noresults'     => 'DynamicPageList: Sem resultados!',
	'intersection_noincludecats' => 'DynamicPageList: É necessário incluir no mínimo uma categoria ou especificar um espaço nominal!',
);

/** Russian (Русский)
 * @author .:Ajvol:.
 */
$messages['ru'] = array(
	'intersection-desc'          => 'Выводит в маркированный список последние добавления в категорию или объединение нескольких категорий',
	'intersection_toomanycats'   => 'DynamicPageList: слишком много категорий!',
	'intersection_toofewcats'    => 'DynamicPageList: слишком мало категорий!',
	'intersection_noresults'     => 'DynamicPageList: нет результатов!',
	'intersection_noincludecats' => 'DynamicPageList: вы должны включить хотя бы одну категорию или указать пространство имён!',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'intersection-desc'          => 'Категорияларга бүтэһик эбиилэри эбэтэр категориялар холбонууларын бэлиэлээх (маркированнай) испииһэк курдук таһаарар',
	'intersection_toomanycats'   => 'DynamicPageList: категорийата наһаа элбэх!',
	'intersection_toofewcats'    => 'DynamicPageList: Категорията наһаа аҕыйах',
	'intersection_noresults'     => 'DynamicPageList: Түмүк суох!',
	'intersection_noincludecats' => 'DynamicPageList: Биир эмит категорияны эбэтэр ааты (пространство имен) талыахтааххын!',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'intersection-desc'          => 'Vypíše zoznam najnovších položiek v kategórii alebo zjednotení niekoľkých kategórií',
	'intersection_toomanycats'   => 'DynamicPageList: Príliš veľa kategórií!',
	'intersection_toofewcats'    => 'DynamicPageList: Príliš málo kategórií!',
	'intersection_noresults'     => 'DynamicPageList: Žiadne výsledky!',
	'intersection_noincludecats' => 'DynamicPageList: Musíte uviesť aspoň jednu kategóriu alebo menný priestor!',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Toufuul Kategorien!',
	'intersection_toofewcats'    => 'DynamicPageList: Toumin Kategorien!',
	'intersection_noresults'     => 'DynamicPageList: Neen Resultoat!',
	'intersection_noincludecats' => 'DynamicPageList: Der mout mindestens een Kategorie ienbuunen weese of reek n Noomensruum oun!',
);

/** Swedish (Svenska)
 * @author Lejonel
 */
$messages['sv'] = array(
	'intersection-desc'          => 'Skapar punktlistor över de nyaste sidorna i en eller flera kategorier',
	'intersection_toomanycats'   => 'DynamicPageList: För många kategorier!',
	'intersection_toofewcats'    => 'DynamicPageList: För få kategorier!',
	'intersection_noresults'     => 'DynamicPageList: Inga resultat!',
	'intersection_noincludecats' => 'DynamicPageList: Du måste inkludera minst en kategori eller ange en namnrymd!',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: చాలా ఎక్కువ వర్గాలు!',
	'intersection_toofewcats'    => 'DynamicPageList: మరీ తక్కువ వర్గాలు!',
	'intersection_noresults'     => 'DynamicPageList: ఫలితాలు లేవు!',
	'intersection_noincludecats' => 'DynamicPageList: మీరు కనీసం ఒక్క వర్గాన్నైనా చేర్చాలి, లేదా ఓ నేమ్&zwnj;స్పేసునైనా ఇవ్వాలి!',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'intersection-desc'          => 'Cho ra danh sách những khoản gần đây nhất được xếp vào một thể loại hay hợp của hơn một thể loại',
	'intersection_toomanycats'   => 'DynamicPageList: Nhiều thể loại quá!',
	'intersection_toofewcats'    => 'DynamicPageList: Ít thể loại quá!',
	'intersection_noresults'     => 'DynamicPageList: Không tìm thấy trang nào!',
	'intersection_noincludecats' => 'DynamicPageList: Cần phải bao gồm ít nhất một thể loại hay định rõ một không gian tên!',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'intersection_toomanycats'   => 'DynamicPageList: Klads tu mödiks!',
	'intersection_toofewcats'    => 'DynamicPageList: Klads tu nemödiks!',
	'intersection_noresults'     => 'DynamicPageList: Seks nonik!',
	'intersection_noincludecats' => 'DynamicPageList: Nedol välön kladi pu bali, u nemaspadi!',
);

