<?php
require_once("AbuseBlocker.php");

if (!Mage::getSingleton( 'customer/session' )->isLoggedIn()){
    $session = Mage::getSingleton( 'customer/session' );
    $session->setBeforeAuthUrl(Mage::getBaseUrl() . substr($_SERVER['REQUEST_URI'],1));
    header("Location: ../customer/account/login");
    exit();
}

/*// force https
  if(!array_key_exists("HTTPS", $_SERVER) || $_SERVER['HTTPS'] != "on" ) {
  $new_url = "https://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
  header("Location: $new_url");
  exit;
  }*/

$versionModel = Mage::getModel('versionlibjacket/version');
$licenseModel = Mage::getModel('licenselibjacket/license');
$customerModel = Mage::getModel('customer/customer');

$TRIAL_LENGTH_IN_DAYS = $licenseModel->getTrialLengthDays();

$customerId = Mage::getModel('customer/session')->getCustomerId();
$customer = $customerModel->load($customerId);
$versions = $versionModel->getVersionsArray();
$versionNames = $versionModel->getVersionNamesArray();
$maxVersion = $versionModel->getCurrentVersionNumber();
$maxVersionDate = $versionModel->getCurrentVersionDate();
$customerLicenses = $licenseModel->getCustomerLicenses($customerId);
$requestVersion = $this->getRequest()->getParam('Version');

// while we scan cookies, also going to look up pending external license
// purchases that need to be bound to the current customer
$licenseExternalUuid = false;
$licenseNumber = false;

// looking for download ID cookies from prior anonymous downloads
foreach ($_COOKIE as $key => $value){
    if (strstr($key, "JACKET_DOWNLOAD_ID")){
        $downloadId = $_COOKIE[$key];
        if ($downloadId != null){
            $link = Mage::getSingleton('core/resource')->getConnection('core_read');
            $downloadId = mysql_escape_string($downloadId);

            $result = $link->query("UPDATE customer_downloads SET entity_id = '"
                                   . $customerId . "' WHERE download_id = '" . $downloadId . "' LIMIT 1");

            // destroy cookie
            setcookie($key, "", time() - 3600);
        }
    }
    else if (strstr($key, "JACKET_EXTERNAL_NUM")){
        $licenseNumber = $_COOKIE[$key];
        setcookie($key, "", time() - 3600);
    }
    else if (strstr($key, "JACKET_EXTERNAL_UUID")){
        $licenseExternalUuid = $_COOKIE[$key];
        setcookie($key, "", time() - 3600);
    }
}

if ($licenseExternalUuid !== false && $licenseNumber !== false){
    $link = Mage::getSingleton('core/resource')->getConnection('core_read');
    $licenseExternalUuid = trim(mysql_escape_string($licenseExternalUuid));
    $licenseNumber = trim(mysql_escape_string($licenseNumber));

    $result = $link->fetchAll("SELECT * FROM license WHERE license_number = '" . $licenseNumber .
                              "' AND external_license_uuid = '" . $licenseExternalUuid . "' and external_claimed = 0");

    if ($result && count($result) == 1){
        $maintenanceDate = time() + (365 * 24 * 60 * 60);

        $link->query("UPDATE license SET customer_id = '" . $customerId .
                     "', external_claimed = 1, maintenance_date = " . $maintenanceDate .
                     " WHERE license_number = '" . $licenseNumber . "' LIMIT 1");
    }
}

if ((Mage::getModel('licenselibjacket/order')
     ->getUnallocatedLicenseOrderCount($customerId) > 0) &&
    ($this->getRequest()->getParam('s') != 'skip'))
{
    header('Location: ' . Mage::getBaseUrl() . 'licenselibjacket/allocate');
    exit();
}

/**
 * Check to make sure that version request is valid.
 */

if (isset($requestVersion) && in_array($requestVersion, $versionNames))
{
    $currentVersion = $requestVersion;
}
else { $currentVersion = $maxVersion; }

$currentVersionDate = $versionModel->getVersionByNumber($currentVersion)
    ->getDate();
$trialVersion = $maxVersion;
$trialVersionDate = date("Ymd", $maxVersionDate);

/**
 * Check to see if any licenses have maxed out their updates.
 * Using own boolean and logic in HTML because Magento requiring refresh for
 * session-stored messages to be displayed.
 */
$tooManyActivations = false;
$maintenanceExpired = false;

$numTrialLicenses = 0;

foreach($customerLicenses as $lic){
    if ($lic['product_sku'] == "000" || $lic['user_type'] == "trial"){
        $numTrialLicenses++;
        continue;
    }

    $maxUpdates = $licenseModel->getMaxAllowedHostChanges($lic);

    if($lic['machine_update'] >= $maxUpdates) {
        $tooManyActivations = true;
    }
    if ($lic['maintenance_date'] < $currentVersionDate && $lic['user_type'] != "trial"){
        $maintenanceExpired = true;
    }
}

/**
 * Helper method that returns the license/user type as a single
 * upper case character.
 */
function licenseType($lic){
    $licUser = 'C';
    if($lic['user_type'] == 'student'){
        $licUser = 'S';
    } elseif($lic['user_type'] == 'academic') {
        $licUser = 'A';
    } elseif($lic['user_type'] == 'government') {
        $licUser = 'G';
    } elseif($lic['user_type'] == 'free'){
        $licUser = 'F';
    }

    return $licUser;
}

/**
 * Helper method that determines whether or not a particular
 * license needs to be updated in the DB before page load.
 */
function licenseNeedsUpdated($request, $license){
    if (!$request->getParam('machine' . $license['license_number']))
        return false;

    if ($license['user_type'] == "trial")
        return false;

    $hostIdChanged = licenseHostIdChanged($request, $license);
    $hostIpChanged = false;
    $hostPortChanged = false;
    if ($license->getCn() > 0){
        // concurrent network license, could have changed IP or Port
        $hostIpChanged = ($license['host_name'] != $request->getParam('hostname' . $license['license_number']));
        $hostPortChanged = ($license['host_port'] != $request->getParam('hostport' . $license['license_number']));
    }

    return $hostIdChanged || $hostIpChanged || $hostPortChanged;
}

/**
 * Helper method that determines whether or not a license's
 * host id has changed.
 */
function licenseHostIdChanged($request, $license){
    if (!$request->getParam('machine' . $license['license_number']))
        return false;

    if (strlen($request->getParam('machine' . $license['license_number'])) != 12)
        return false;

    return ($license['host_id'] != $request->getParam('machine' . $license['license_number']));
}


function validHostId($hostId){
    if (empty($hostId)) return false;

    return strlen(preg_replace("/[^0-9a-fA-F]+/", "", $hostId)) == 12;
}

function validHostName($hostName){
    // not much we can do since could be an IP or a hostname
    return !empty($hostName);
}

function validPort($port){
    return $port > 0 && $port < 65535;
}

function version_changed($license, $currentVersion){
    $is_different = version_compare($license['version'], $currentVersion) != 0;
    return $is_different;
}

if ($this->getRequest()->getParam('genFlex'))
{
    foreach($customerLicenses as $lic){
        $reqName = 'machine' . $lic['license_number'];

        $successDisplayed = false;
        $errorDisplayed = false;

        if (licenseNeedsUpdated($this->getRequest(), $lic) || version_changed($lic, $currentVersion)){
            $license = $licenseModel->load($lic['license_number']);

            $originalHostId = $lic['host_id'];

            $updateSuccess = true;

            if (validHostId($this->getRequest()->getParam($reqName))){
                $license->setLicenseCode($licenseModel->generateLicenseCode());
                $license->setHostId(preg_replace("/[^0-9a-fA-F]+/", "", $this->getRequest()->getParam($reqName)));
                $license->setVersion($currentVersion);

                if ($license->getCn() > 0){
                    if (validPort($this->getRequest()->getParam('hostport' . $lic['license_number']))){
                        if (validHostName($this->getRequest()->getParam('hostname' . $lic['license_number']))){
                            $license->setHostName($this->getRequest()->getParam('hostname' . $lic['license_number']));
                            $license->setHostPort($this->getRequest()->getParam('hostport' . $lic['license_number']));
                        }
                        else{
                            $updateSuccess = false;
                            Mage::getSingleton('core/session')->addError("An invalid IP / hostname was specified for license " .
                                                                         licenseType($lic) . $lic['license_number'] .
                                                                         ". Please try again with a correct value.");
                            $errorDisplayed = true;
                        }
                    }
                    else{
                        $updateSuccess = false;
                        Mage::getSingleton('core/session')->addError("An invalid port was specified for license " .
                                                                     licenseType($lic) . $lic['license_number'] .
                                                                     ".  Please try again with a correct value.");
                        $errorDisplayed = true;
                    }
                }

                $license->update(licenseHostIdChanged($this->getRequest(), $lic));

                $license->generateFlexLicense($currentVersion);

                if ($updateSuccess){
                    if ($license->getHostId() != $originalHostId){
                        $eventEmail = Mage::getSingleton('customer/session')->getCustomer()->getEmail();
                        $eventLicenseNumber = $lic['license_number'];
                        $eventOldId = $originalHostId;
                        $eventNewId = $license->getHostId();

                        $eventData['email'] = $eventEmail;
                        $eventData['licenseNumber'] = $eventLicenseNumber;
                        $eventData['oldId'] = $eventOldId;
                        $eventData['newId'] = $eventNewId;

                        Mage::dispatchEvent('host_id_changed', array('eventdata' => $eventData));

                        $customLink = Mage::getSingleton('core/resource')->getConnection('core_read');
                        $customLink->query("INSERT INTO license_host_changes "
                                           . "(license_number, customer_id, previous_value, new_value) VALUES ("
                                           . "'" . $license->getLicenseNumber() . "','" . $customerId
                                           . "','" . $originalHostId . "','" . $license->getHostId() . "')");
                    }

                    Mage::getSingleton('core/session')->addSuccess("License " . licenseType($lic) . $lic['license_number'] . " was updated!");
                    $successDisplayed = true;
                }
            }
            else{
                if ($this->getRequest()->getParam($reqName) != ""){
                    Mage::getSingleton('core/session')->addError("An invalid host id was specified for license ".
                                                                 licenseType($lic) . $lic['license_number'] .
                                                                 ".  Please try again with a correct value.");
                    $errorDisplayed = true;
                }
            }
        }

        // handle custom label separately as those could be updated constantly
        if ($this->getRequest()->getParam('hostlabel' . $lic['license_number'])){
            if ($lic['host_label'] != $this->getRequest()->getParam('hostlabel' . $lic['license_number'])){
                $license = $licenseModel->load($lic['license_number']);
                $license->setHostLabel($this->getRequest()->getParam('hostlabel' . $lic['license_number']));
                if (!$successDisplayed && !$errorDisplayed){
                    Mage::getSingleton('core/session')->addSuccess("License " . licenseType($lic) . $lic['license_number'] . " was updated!");
                }
                $license->save();
            }
        }
    }

    header("Location: " . Mage::getBaseUrl() . "licenses_libjacket/?Version=" . $currentVersion);
    exit();
}

if ($this->getRequest()->getParam('startTrial'))
{
    if (AbuseBlocker::is_banned_ip($_SERVER['REMOTE_ADDR'])){
        Mage::getSingleton('core/session')->addError("Trial license not available for this account. "
        . "Contact <a href='mailto:sales@accelereyes.com'>sales@accelereyes.com</a> if any questions.");
        header("Location: /licenses_libjacket");
        exit();
    }
    else if ($licenseModel->hasTrialLicense($customerId) == 0)
    {
        $license = $licenseModel;
        $month = date('m');
        $day = date('d');
        $year = date('Y');
        $license->setGfxToolbox(1);
        $license->setMgl(16);
        $license->setJla(1);
        $license->setSla(1);


        $license->setCustomerId($customerId);
        $license->setUserType('trial');
        $pDate = mktime(0,0,0,$month, $day, $year);
        $mDate = $pDate + ($TRIAL_LENGTH_IN_DAYS * 86400);
        $license->setPurchaseDate($pDate);
        $license->setMaintenanceDate($mDate);
        $license->setProductSku('000');
        $license->setMachineId('JUSTIN:BAILEY');
        $license->setVersion($maxVersion);
        $license->setLicenseCode($license->generateLicenseCode());
        $license->save();

        Mage::dispatchEvent('begin_trial', array(
                                'license'=>$license,
                                'customer'=>$customer,
                                'baseproduct'=>'libjacket',
                                ));

        $license->generateTrialLicense($maxVersion);

        Mage::getSingleton('core/session')->addSuccess("Trial license generated.  Click the link below to download it.");


        //NOTE: krunal - hard-coded the 21 for now, need to put into config.xml
        Mage::getModel('core/email_template')
            ->sendTransactional(
                21,
                Mage::getStoreConfig('sales_email/new_trial/identity', $this->getStoreId()),
                Mage::getSingleton('customer/session')->getCustomer()->getEmail(),
                Mage::helper('customer')->getCustomerName(),
                array(
                    'customer'      => Mage::getSingleton('customer/session')->getCustomer(),
                    'billing'       => Mage::getSingleton('customer/session')->getCustomer()->getBillingAddress(),
                    )
                );

        header("Location: " . Mage::getBaseUrl() . "licenses_libjacket/?Version=" . $currentVersion);
        exit();
    }
}

?>

<div class="left2">
  <div class="clearfix"></div>
  <?php echo $this->getMessagesBlock()->getGroupedHtml() ?>

  <?php if ($tooManyActivations){ ?>
  <ul>
    <li class="notice-msg">
      One or more of your licenses has reached the maximum number of Host ID
      updates allowed and can no longer be updated.  Please
      contact <a href="mailto:sales@accelereyes.com">sales@accelereyes.com</a>
      for assistance.
    </li>
  </ul>
  <?php } ?>
  <?php if ($maintenanceExpired){ ?>
  <ul>
    <li class="notice-msg">
      One or more of your licenses do not qualify for version
      <?= $currentVersion ?> because the maintenance date is expired.
    </li>
  </ul>
  <?php } ?>

  <h2>Manage LibJacket Licenses</h2>

  <table width="100%">
  <tr>
  <td width="52%">
  <p>
    To start a LibJacket trial, go to the bottom of this page. To purchase
    LibJacket, go to the <a href="/purchase#purchaseFormTab2">purchase page</a>.
  </p>

  <p>
    If you need assistance getting started,
    email <a href="mailto:support@accelereyes.com">support@accelereyes.com</a> or call (800) 570-1941 x2.
  </p>
  </td>
  <td align="center">
  <img src="/content/images/libjacket_logo.png" style="margin:-40px 20px; width:50%"/>
  </td>
  </tr>
  </table>


  <br/>

  <h3>Download</h3>
  Select the LibJacket version you wish to download and manage:
  <form action="" method="get">
    <select name="Version" onChange="this.form.submit();">
      <?php
         $versions = Mage::helper('version')->sortVersionsByNumber($versions);

      foreach($versions as $version){
      echo '<option value="' . $version['version_number'] . '"';
                    if($currentVersion == $version['version_number']){ echo ' SELECTED'; }
                    echo '>v' . $version['version_number'] . '</option>';
      }
      ?>
    </select>
  </form>

  <hr/>

  <table border=0 width=100% id="shopping-cart-table">
    <tr>
      <td align="center">
        <a href="<?php echo Mage::getBaseUrl().'download.php?f=http://files.accelereyes.com/installers/'.$versionModel->getDownloadFileName($currentVersion, "windows"); ?>">
          <img src="/content/images/download-windows.png" /></a>
        <br/>&nbsp;
      </td>
      <td align="center">
        <a href="<?php echo Mage::getBaseUrl().'download.php?f=http://files.accelereyes.com/installers/'.$versionModel->getDownloadFileName($currentVersion, "linux"); ?>">
          <img src="/content/images/download-linux.png" /></a>
        <br/>&nbsp;
      </td>
      <td align="center">
        <a href="<?php echo Mage::getBaseUrl().'download.php?f=http://files.accelereyes.com/installers/'.$versionModel->getDownloadFileName($currentVersion, "osx"); ?>">
          <img src="/content/images/download-mac.png" /></a>
        <br/>&nbsp;
      </td>
    </tr>
  </table>

  <p>
    By downloading and installing, you agree to
    the <a href="<?php Mage::getBaseUrl() ?>eula">LibJacket EULA</a>.
  </p>

  <!-- vertical response analytics click-to-converstion tracking -->
  <img src="https://cts.vresp.com/s.gif?h=03cd632607" height="1" width="1"/>

  <br/><br/>

  <h3>Purchased Developer Licenses (Single Computer)</h3>

  <form method='post' action=''>
    <table class="license-table" class="manage_licenses">
      <tr>
        <th class="license-table-numlic">License<br/>Number</th>
        <th class="license-table-purchasedate">Purchase<br/>Date</th>
        <th class="license-table-mainexpir">Maintenance<br/>Expiration</th>
        <th class="license-table-supportexpir">Support<br/>Expiration</th>
        <th class="license_table_jacketid">Custom Label<br />(Optional)</th>
        <th class="license-table-features">Features</th>
        <th class="license-table-jacketid">Host ID</th>
        <th class="license-table-jacketplp">License Download</th>
      </tr>

<?php
          $nonTrialCount = 0;
foreach($customerLicenses as $lic){

    if ($lic['product_sku'] == '000' || $lic['user_type'] == 'trial') { continue; }
    if ($lic->getCn()) { continue; }

    $nonTrialCount++;

    $fullLicense = licenseType($lic) . $lic['license_number'];

    $maxUpdates = $licenseModel->getMaxAllowedHostChanges($lic);

    $invalidForSelectedVersion = (($lic['maintenance_date'] < $currentVersionDate)||($lic['machine_update'] >= $maxUpdates));

    if (!$invalidForSelectedVersion){
        if ($lic['maintenance_date'] < time() && $lic['user_type'] == 'free'){
            $invalidForSelectedVersion  = true;
        }
    }

    if ($invalidForSelectedVersion){
        echo '<tr bgcolor=#faebe7>';
    }
    else{
        if( ($nonTrialCount % 2) == 1 ) {
            echo '<tr  bgcolor=#f8f7f5>';
        } else {
            echo '<tr  bgcolor=#eeeded>';
        }
    }

    echo '<td class="license-table-numlic">', $fullLicense, '</td>';
    echo '<td class="license-table-purchasedate">', gmdate("m/d/y", $lic['purchase_date']-18000) , '</td>';
    echo '<td class="license-table-mainexpir">', gmdate("m/d/y", $lic['maintenance_date']-18000), '</td>';

    if(($lic['support_date'] != NULL)&&($lic['support_date'] != 0)){
        echo '<td class="license-table-supportexpir">', gmdate("m/d/y", $lic['support_date']-18000), '</td>';
    }
    else {
        echo '<td class="license-table-supportexpir">Not Purchased</td>';
    }

    echo '<td class="license-table-features">';
    echo '<input style="width:80px" type="text" value="' . $lic['host_label'] . '" name="hostlabel' . $lic['license_number'] . '"/>';
    echo '</td>';

    $features = "";
    if ($lic['mgl'] > 0) $features .= "mgl" . $lic['mgl'];
    if ($lic['jla'] > 0){
        if (strlen($features) > 0) $features .= ", ";
        $features .= "dla";
    }
    if ($lic['sla'] > 0){
        if (strlen($features) > 0) $features .= ", ";
        $features .= "sla";
    }









    echo '<td class="license-table-features">'.strtoupper($features).'</td>';

    if ($invalidForSelectedVersion){
        echo '<td class="license-table-jacketid"><input type="text" name="machine' . $lic['license_number'] .
            '" value="' . $lic['host_id'] . '" readonly/>';
        echo '<div style="color: #df280a">';
        echo ($lic['machine_update'] >= $maxUpdates)? "Too Many Activations" : "Not Available for ".$currentVersion;
        echo '</div>';
        echo '</td>';
    }
    else {
        echo '<td class="license-table-jacketid"><input type="text" name="machine' . $lic['license_number'] .
            '" class="hwaddr" value="' . $lic['host_id'] . '"></td>';
    }


    if(file_exists('./license-downloads/license'.$lic['license_code'].'.lic')
       && ($lic['license_code']) && !$invalidForSelectedVersion && !empty($lic['host_id'])){
        echo '<td class="license-table-jacketplp">
             <a href="/downloadlicenselibjacket?f=license'
            . $lic['license_code'] . '.lic' . '&fc=libjacket.lic&license_number='.$lic['license_number'].'&license_version='.$currentVersion.'">Download License</a></td>';
    } else {
        echo '<td class="license-table-jacketplp">Submit Host ID</td>';
    }

    echo '</tr>';
}

if ($nonTrialCount == 0) { echo '<tr><td colspan="8">Click <a href="' . Mage::getBaseUrl() . 'purchase">Here</a> to purchase a LibJacket License.</td></tr>'; }
?>
    </table>

<?php if ($nonTrialCount != 0): ?>
    <span style="float:right; margin-top:10px;">
      <input type="hidden" name="genFlex" value="yes">
      <button class="form-button-alt" type="submit">Submit Host Information</button>
    </span>
<?php endif; ?>

  </form>

  <br/><br/>

  <?php if (count($licenseModel->getCustomerConcurrentNetworkLicenses($customerId)) > 0): ?>

  <br/><br/><br/>

  <h3>Purchased Concurrent Network Licenses</h3>

  <p>
    Please provide the HostID, IP (or Hostname), and Port for your license
    server. In addition to the license file, you must download and run the
    Concurrent Network Server (see below).
  </p>

  <form method='post' action=''>
    <table class="license-table" class="manage_licenses">
      <tr>
        <th class="license-table-numlic">License<br/>Number</th>
        <th class="license-table-purchasedate">Purchase<br/>Date</th>
        <th class="license-table-mainexpir">Maintenance<br/>Expiration</th>
        <th class="license-table-supportexpir">Support<br/>Expiration</th>
        <th class="license-table-features">Custom Label<br />(Optional)</th>
        <th class="license-table-features">Features</th>
        <th class="license-table-jacketid">Server Information</th>
        <th class="license-table-jacketplp">License Download</th>
      </tr>
<?php
      $nonTrialCount = 0;
$customerCnLicenses = $licenseModel->getCustomerConcurrentNetworkLicenses($customerId);

foreach($customerCnLicenses as $lic){

    if ($lic['product_sku'] == '000' || $lic['user_type'] == 'trial') { continue; }

    $nonTrialCount++;

    $fullLicense = licenseType($lic) . $lic['license_number'];
    $maxUpdates = $licenseModel->getMaxAllowedHostChanges($lic);

    $invalidForSelectedVersion = (($lic['maintenance_date'] < $currentVersionDate)||($lic['machine_update'] >= $maxUpdates));

    if (!$invalidForSelectedVersion){
        if ($lic['maintenance_date'] < time() && $lic['user_type'] == 'free'){
            $invalidForSelectedVersion = true;
        }
    }

    if ($invalidForSelectedVersion){
        echo '<tr bgcolor=#faebe7>';
    }
    else{
        if( ($nonTrialCount % 2) == 1 ) {
            echo '<tr  bgcolor=#f8f7f5>';
        } else {
            echo '<tr  bgcolor=#eeeded>';
        }
    }

    echo '<td class="license-table-numlic">', $fullLicense, '</td>';
    echo '<td class="license-table-purchasedate">', gmdate("m/d/y", $lic['purchase_date']-18000) , '</td>';
    echo '<td class="license-table-mainexpir">', gmdate("m/d/y", $lic['maintenance_date']-18000), '</td>';

    if(($lic['support_date'] != NULL)&&($lic['support_date'] != 0)){
        echo '<td class="license-table-supportexpir">', gmdate("m/d/y", $lic['support_date']-18000), '</td>';
    }
    else {
        echo '<td class="license-table-supportexpir">N/A</td>';
    }

    echo '<td class="license-table-features">';
    echo '<input style="width:80px" type="text" value="' . $lic['host_label'] . '" name="hostlabel' . $lic['license_number'] . '"/>';
    echo '</td>';


    echo '<td class="license-table-features"><table class="inner-license-table">';
    echo '<tr><td>BASE</td><td>' . $lic['cn'] . '</td></tr>';
    echo '<tr><td>MGL</td><td>' . $lic['mgl'] . '</td></tr>';
    echo '<tr><td>DLA</td><td>' . $lic['jla'] . '</td></tr>';
    echo '<tr><td>SLA</td><td>' . $lic['sla'] . '</td></tr>';
    echo '<tr><td>HPC</td><td>' . $lic['hpc'] . '</td></tr>';
    echo '</table></td>';



    $readOnly = ($invalidForSelectedVersion)? "readonly" : "";

    echo '<td class="license-table-jacketid">';
    echo '<table class="inner-license-table">';

    echo '<tr><td>HostID:</td><td>';
    echo '<input type="text" name="machine' . $lic['license_number'] . '" value="' . $lic['host_id'] . '" '.$readOnly.'/><br />';
    echo '</td></tr>';

    echo '<tr><td>IP:</td><td>';
    echo '<input type="text" name="hostname' . $lic['license_number'] . '" value="' . $lic['host_name'] . '" '.$readOnly.'/><br />';
    echo '</td></tr>';

    if (empty($lic['host_port'])) $lic['host_port'] = $licenseModel->getDefaultServerPort();

    echo '<tr><td>Port:</td><td>';
    echo '<input type="text" name="hostport' . $lic['license_number'] . '" value="' . $lic['host_port'] . '" '.$readOnly.'/><br />';
    echo '</td></tr>';

    echo '</table>';

    if ($invalidForSelectedVersion){
        echo '<div style="color: #df280a">';
        echo ($lic['machine_update'] >= $maxUpdates)? "Too Many Activations" : "Not Available for ".$currentVersion;
        echo '</div>';
    }

    echo '</td>';

    if(file_exists('./license-downloads/license'.$lic['license_code'].'.lic')
       && ($lic['license_code']) && !$invalidForSelectedVersion && !empty($lic['host_id'])
       && !empty($lic['host_name']) && !empty($lic['host_port'])){
        echo '<td class="license-table-jacketplp">
             <a href="/downloadlicenselibjacket?f=license'
            . $lic['license_code'] . '.lic' . '&fc=libjacket.lic&license_number='.$lic['license_number'].'&license_version='.$currentVersion.'">Download License</a></td>';
    } else {
        echo '<td class="license-table-jacketplp">Run Submit Host ID</td>';
    }

    echo '</tr>';
}

if ($nonTrialCount == 0) { echo '<tr><td colspan="8">Click <a href="' . Mage::getBaseUrl() . 'purchase">Here</a> to purchase a LibJacket License.</td></tr>'; }
?>
    </table>

    <span style="float:right; margin-top:10px;">
      <input type="hidden" name="genFlex" value="yes">
      <button class="form-button-alt" type="submit">Submit Host Information</button>
    </span>
  </form>

  <br/><br/>
  <h3>Concurrent Network Server</h3>

  <p>
    Download the version that matches the OS and architecture of the machine
    that will be your license server.
  </p>

  <table width="50%">
    <tr>
      <td>Linux:</td><td><a href="http://www.accelereyes.com/download.php?f=license_server_bins/cn-jacket-linux-x86.tgz">32bit</a> | <a href="http://www.accelereyes.com/download.php?f=license_server_bins/cn-jacket-linux-x64.tgz">64bit</a></td>
    </tr>
    <tr>
      <td>Windows:</td><td><a href="http://www.accelereyes.com/download.php?f=license_server_bins/cn-jacket-windows-x86.zip">32bit</a> | <a href="http://www.accelereyes.com/download.php?f=license_server_bins/cn-jacket-windows-x64.zip">64bit</a></td>
    </tr>
    <tr>
      <td>OSX:</td><td><a href="http://www.accelereyes.com/download.php?f=license_server_bins/cn-jacket-osx.tgz">32bit</a></td>
    </tr>
  </table>

  <?php endif; ?>

  <br/>
  <h3 id="trial">Trial License</h3>

  <?php
     $link = Mage::getSingleton('core/resource')->getConnection('core_read');
  $result = $link->query("SELECT can_trial FROM customer_entity WHERE entity_id = '$customerId'");
  $result = $result->fetch();
  ?>

  <?php if ($numTrialLicenses == 0 && $result['can_trial'] != 0) { ?>
  <table>
    <tr>
      <td width="10%">
        <form method='post' action=''>
          <span style="float:left; margin-top:8px;margin-bottom:10px;">
            <input type="hidden" name="startTrial" value="yes">
            <button class="form-button-alt" type="submit">Start Trial</button>
          </span>
        </form>
      </td>
      <td>
        To start a 15-day trial, click the Start Trial button on the left.  If
        your trial period is over,
        contact <a href="mailto:sales@accelereyes.com">sales@accelereyes.com</a>
        to purchase or to let us know if you have any further inquiries.
      </td>
    </tr>
  </table>
  <? } ?>

  <table class="license-table">
    <tr bgcolor=#c2d3e0>
      <th class="license-table-numlic">License<br/>Number</th>
      <th class="trial-license-table-startdate">Start<br/>Date</th>
      <th class="trial-license-table-enddate">End<br/>Date</th>
      <th class="trial-license-table-blank">LibJacket Version</th>
      <th class="license-table-jacketplp">License File</th>
    </tr>
<?php

       $trialCount = 0;
foreach($customerLicenses as $lic){

    if ($lic['user_type'] != 'trial') { continue; }

    $trialCount++;
    $fullLicense = 'T' . $lic['license_number'];

    if( ($trialCount % 2) == 1 ) {
        echo '<tr  bgcolor=#f8f7f5>';
    } else {
        echo '<tr  bgcolor=#eeeded>';
    }
    echo '<td class="license-table-numlic">', $fullLicense, '</td>';
    echo '<td class="trial-license-table-startdate">', gmdate("m/d/y", $lic['purchase_date']) , '</td>';
    echo '<td class="trial-license-table-enddate">', gmdate("m/d/y", $lic['maintenance_date']), '</td>';
    echo '<td class="trial-license-table-blank">v' . $lic['version'] .' </td>';
    echo '<td class="license-table-jacketplp">';
    if(!is_null($lic['license_code']) && ($lic['maintenance_date'] >= time()))
    {
        echo '<a href="/downloadlicenselibjacket?f=license'
            . $lic['license_code'] . '.lic' . '&fc=libjacket.lic&license_number='.$lic['license_number'].'&license_version='.$currentVersion.'">Click Here to Download Trial License</a>';
    } else if ($lic['maintenance_date'] < time()) {
        echo 'Your trial has expired.';
    } else {
        echo 'Please click "Start Trial" to generate your trial license.';
    }
    echo '</td>';
    echo '</tr>';
}

if ($trialCount == 0) {
    echo '<tr><td colspan="5">Please click "Start Trial" to generate your trial license</td></tr>';
}
?>
  </table>
  <br/>
</div><!--left2-->

<div class="clearfix">
</div>
