<?php 
require_once("AbuseBlocker.php");

class CustomFunctions
{

    public static function _empty($string){
        $string = trim($string);
        if(!is_numeric($string)) return empty($string);
        return FALSE;
    } 

    public static function getLoggedInCustomerInfo()
    {
        if (!Mage::getSingleton( 'customer/session' )->isLoggedIn())
        {
            return null;
        }
        
        $customer = Mage::getSingleton('customer/session')->getCustomer();

        $first_name = $customer->getFirstname();
        $last_name = $customer->getLastname();
        $company = $customer->getCompany();
        $email = $customer->getEmail();

        return array($first_name,$last_name,$company,$email);

    }

    public static function processPopUpForm($prefix,$event)
    {
        $your_first_name = @trim(htmlspecialchars($_POST[$prefix . 'your-first-name']));
        $your_last_name =  @trim(htmlspecialchars($_POST[$prefix . 'your-last-name']));
        $your_company =  @trim(htmlspecialchars($_POST[$prefix . 'your-company']));
        $your_email =  @trim(htmlspecialchars($_POST[$prefix . 'your-email']));
        $your_phone =  @trim(htmlspecialchars($_POST[$prefix . 'your-phone']));
        $your_comments = @trim(htmlspecialchars($_POST[$prefix . 'your-comments']));
        $your_how = @trim(htmlspecialchars($_POST[$prefix . 'your-howd-you-hear-about-us']));

        if (!empty($_POST))
        {
            if (CustomFunctions::_empty($your_first_name) || CustomFunctions::_empty($your_last_name) || CustomFunctions::_empty($your_email)  || !filter_var($your_email,FILTER_VALIDATE_EMAIL) || CustomFunctions::_empty($your_company))
            {
                //ok some required field is missing
                return "<div style='color: red;'>Some required data was entered<br/>incorrectly. Please click <a href='/'>here</a> <br/>and try again.</div>";
            } else
            {
                //sucess
                if (!CustomFunctions::_empty($your_how))
                {
                    $desc = "How did you hear about us: " . $your_how . "\nComments: " . $your_comments;
                } else
                {
                    $desc = "Comments: " . $your_comments;
                }
                //ok let salesforce know
                Mage::dispatchEvent($event, array('first_name'=>$your_first_name, 'last_name'=>$your_last_name, 'email'=>$your_email, 'description'=>$desc, 'company'=>$your_company, 'phone'=>$your_phone, 'send_email'=>true));
                return "<b>Success!</b> Please check your email for further details.";
            }
        }
        
        return '';
    }

    /* Searches haystack for needle and returns an array of the key path if it is found in the (multidimensional) array, FALSE otherwise. */
    /* mixed array_searchRecursive ( mixed needle, array haystack [, bool strict[, array path]] ) */
    public static function array_searchRecursive( $needle, $haystack, $strict=false, $path=array() )
    {
        if( !is_array($haystack) ) {
            return false;
        }

        foreach( $haystack as $key => $val ) {
            if( is_array($val) && $subPath = CustomFunctions::array_searchRecursive($needle, $val, $strict, $path) ) {
                $path = array_merge($path, array($key), $subPath);
                return $path;
            } elseif( (!$strict && $val == $needle) || ($strict && $val === $needle) ) {
                $path[] = $key;
                return $path;
            }
        }
        return false;
    } 


    public static function registerCreateLicense()
    {

        //generate any license that may be required
        if (Mage::getSingleton('core/session')->getRegCreateLicense())
        {
            //unset the regestration of creating a license
            Mage::getSingleton('core/session')->setRegCreateLicense(false);

            if (AbuseBlocker::is_banned_ip($_SERVER['REMOTE_ADDR'])){
                Mage::getSingleton('core/session')->addError("Trial license not available for this account. "
                                                             . "Contact sales@accelereyes.com if any questions.");
                return;
            }

            $product = Mage::getSingleton('core/session')->getRegProduct();
            $hostid = Mage::getSingleton('core/session')->getRegHostId();

            $products = array('jacket','arrayfire');

            if (in_array($product,$products))
            {
                $license = null;
                $versionModel = null;
                $baseproduct = null;
                $templateid = null;
                $store_id = Mage::app()->getStore()->getId();

                if ($product === "jacket")
                {
                    $license = Mage::getModel('license/license');
                    $versionModel = Mage::getModel('version/version');
                    $baseproduct = "Jacket";
                    $license->setJmc(1);
                    $license->setSdk(1);
                    $templateid = Mage::getStoreConfig('sales_email/new_trial/template', $store_id);
                } else
                {
                    $license = Mage::getModel('licenselibjacket/license');
                    $versionModel = Mage::getModel('versionlibjacket/version');
                    $baseproduct = "libJacket";
                    $templateid = 21;
                }


                /* $licenses = $license->getResourceCollection()->addFieldToFilter("host_id", $hostid)->addFieldToFilter("user_type", 'trial'); */


                $customerId = Mage::getModel('customer/session')->getCustomerId();

                if ($license->hasTrialLicense($customerId) == 0)
                {
                    $maxVersion = $versionModel->getCurrentVersionNumber();
                    $customerModel = Mage::getModel('customer/customer');
                    $customer = $customerModel->load($customerId);
                    $TRIAL_LENGTH_IN_DAYS = $license->getTrialLengthDays();

                    //most important thing, set the host id!!!
                    $license->setHostId($hostid);

                    $month = date('m');
                    $day = date('d');
                    $year = date('Y');
                    $license->setGfxToolbox(1);
                    $license->setMgl(16);
                    $license->setJla(1);
                    $license->setSla(1);
                    $license->setCustomerId($customerId);
                    $license->setUserType('trial');
                    $pDate = mktime(0,0,0,$month, $day, $year);
                    $mDate = $pDate + ($TRIAL_LENGTH_IN_DAYS * 86400);
                    $license->setPurchaseDate($pDate);
                    $license->setMaintenanceDate($mDate);
                    $license->setProductSku('000');
                    $license->setMachineId('JUSTIN:BAILEY');
                    $license->setVersion($maxVersion);
                    $license->setLicenseCode($license->generateLicenseCode());
                    $license->save();

                    Mage::dispatchEvent('begin_trial', array(
                                            'license'=>$license,
                                            'customer'=>$customer,
                                            'baseproduct'=>$baseproduct,
                                            ));

                    $license->generateTrialLicense($maxVersion);

                    Mage::getSingleton('core/session')->addSuccess("Trial license generated.  Check your terminal to obtain new license.");

                    Mage::getModel('core/email_template')
                        ->sendTransactional(
                            $templateid,
                            Mage::getStoreConfig('sales_email/new_trial/identity', $store_id),
                            Mage::getSingleton('customer/session')->getCustomer()->getEmail(),
                            Mage::helper('customer')->getCustomerName(),
                            array(
                                'customer'      => Mage::getSingleton('customer/session')->getCustomer(),
                                'billing'       => Mage::getSingleton('customer/session')->getCustomer()->getBillingAddress(),
                                )
                            );
                }
            }
        }
    }

}

?>