<?php
   /**
   * Gets included in download_jacket.phtml if windows OS is detected.
   */
   ?>

<div class="download_instructions_container">

  <div class="header">Windows Installation Instructions</div>
  <div class="links">
     Test

    <p><a href="#section_2">Installation</a> | <a href="#section_3">Driver
    Configuration</a> | <a href="#section_4">Activation</a>
    | <a href="#section_5">Additional Help</a>
  </div>

  <div class="section" id="section_1">
    <div class="header">Download and Run the Installer</div>

    <table>
      <tr>
        <td>Click 'Save' when prompted by your browser.</td>
      </tr>
      <tr>
        <td>When the download is complete, hit 'Run' or double click the
        downloaded .exe file.</td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_2">
    <div class="header">Installation</div>

    <table>
      <tr>
        <td class="info">Click 'Next' when presented with the Installer welcome screen.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_welcome.png" alt="Installer Welcome"/></td>
      </tr>
      <tr>
        <td class="info">Review and accept the presented license agreement and then click 'Next'.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_eula.png" alt="End User License Agreement"/></td>
      </tr>
      <tr>
        <td class="info">Choose the installation location and then click 'Next'.  Note that AccerEyes\Jacket will be appended to the installation path you select.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_location.png" alt="Choose Installation Location"/></td>
      </tr>
      <tr>
        <td class="info">On the next screen click 'Install' to begin the installation of Jacket to the location you chose in the previous step.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_ready.png" alt="Ready to Install"/></td>
      </tr>
      <tr>
        <td class="info">Select the MATLAB version installed on your system and then click 'Next'.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_matlab_version.png" alt="Choose MATLAB version"/></td>
      </tr>
      <tr>
        <td class="info">After installation is complete you can continue with license activation.  You may first be prompted to address driver issues as detailed below.</td>
        <td class="image"></td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">Driver Configuration</div>

    <table>
      <tr>
        <td class="info">If you are running Windows Vista, Windows Server, or
        Windows 7 you may receive this driver timeout related prompt.  Click
        'Yes' and then 'Ok' to reboot your machine if this option is
        presented.  This will ensure that long running or resource intensive
        operations on the GPU do not timeout before completion.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_timeout.png" alt="Graphics Driver Timeout"/></td>
      </tr>
      <tr>
        <td class="info">The Jacket installer will search for a CUDA capable
        driver on your machine and if one cannot be detected you will receive
        this prompt.  Either click the Nvidia button in the installer or visit
        Nvidia's <a href="http://www.nvidia.com/object/cuda_get.html"
        target="_blank">CUDA Download Page</a> to download the driver.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_cuda.png" alt="CUDA Download"/></td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_4">
    <div class="header">Activation</div>

    <table>
      <tr>
        <td class="info">When prompted to download your license file click
        'Yes' unless you would prefer to manually activate using
        the <a href="/licenses" target="_blank">Manage Licenses Page</a>.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_activate.png" alt="Activate License"/></td>
      </tr>
      <tr>
        <td class="info">Enter the e-mail and password for your account.  If
        you do not have an account <a href="/customer/account/create"
        target="_blank">Click Here</a> to create one.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_login.png" alt="Login to AccelerEyes.com"/></td>
      </tr>
      <tr>
        <td class="info">After logging in you will be presented with a list of
          your valid licenses.  Licenses displayed in red are not eligible for
          usage with the current version of Jacket due to an expired
          maintenance date.<br />  <br /> Select the license that you would
          like to use with your current machine and click 'Ok'.  You can visit
          your <a href="/licenses" target="_blank">Manage Licenses Page</a>
          for more information about the licenses you have available.</td>
        <td class="image"><img src="/content/images/installer/instructions_windows_licenses.png" alt="License Selection"/></td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_5">
    <div class="header">Additional Help</div>

    <table>
      <tr>
        <td>
          For instructions on installing Jacket for OSX please refer to
          the <a href="http://wiki.accelereyes.com/wiki/index.php/Jacket_Installation"
          target="_blank">Documentation Section</a> of our website. For
          additional assistance join the <a href="/forums"
          target="_blank">Jacket Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>
  </div>

</div>
