<?php
   /**
   * Gets included in download_jacket.phtml if windows OS is detected.
   */
   ?>

<div class="download_instructions_container">

  <div class="header">ArrayFire CUDA Windows Installation Instructions</div>
  <div class="links">
     <a href="#section_1">Installation</a><br>
     <a href="#section_2">ArrayFire with Visual Studio</a><br>
     <a href="#section_3">Setting Environment Variables</a><br>
     <a href="#section_4">Verifying CUDA</a><br>
     <a href="#section_5">Support</a><br>
     <a href="#section_6">ArrayFire Licensing</a>
  </div>
  <br><br>
  <div class="header">ArrayFire OpenCL Windows Installation Instructions</div>
  <div class="links">
     <a href="#section_7">Installation</a>
  </div>

  <div class="section" id="section_1">
    <div class="header">Installation</div>

    <table>
      <tr>
        <td>Click 'Save' when prompted by your browser.</td>
      </tr>
      <tr>
     <td>
     <br>
     Unzip the downloaded package choosing a destination directory, for example, <code>C:\Users\accelereyes</code>.
     After the extraction completes, you will see arrayfire directory created
     inside the destination directory <code>(C:\Users\accelereyes\arrayfire)</code>.
     </td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_2">
    <div class="header">ArrrayFire with Visual Studio</div>
        <br>                                                                                      
        ArrayFire includes examples compatible with both Visual Studio 2008 and 2010.
        For example, open <code>(C:\Users\accelereyes\arrayfire\examples\misc\hello_world_vs2008.sln)</code> in VS 2008.<br><br>
    <table>
      <tr>
        <td class="info">
        Choose an appropriate build mode from the menubar (e.g. <code>Release x64</code>), and select Run
        <img src="/content/images/installer/instructions_af_run.png" alt="Visual Studio run"/></td>.
     </td>
        <td class="image"><img src="/content/images/installer/instructions_af_vs_2008.png" alt="Building ArrayFire examples"/></td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">Setting Environment Variables</div>
    <br>
    (Recommended) To build and run ArrayFire examples outside the example directory, e.g. move an ArrayFire example folder elsewhere, do the following : 
    <br>

    <table>
      <tr>
        <td class="info">Right-click on "Computer" icon on your Desktop and select Properties.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_computer_properties.png" alt="Computer Properties"/></td>
      </tr>
      <tr>
        <td class="info">In the system window, click on "Advanced system settings" in the left panel.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_advanced_system_settings.png" alt="Advanced System Settings"/></td>
      </tr>
      <tr>
        <td class="info">In the System Properties window, select the "Advanced" tab and click on "Environment Variables" button
        given at the bottom of the window as highlighted.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_systems_window.png" alt="Systems Window"/></td>
      </tr>
      <tr>
    <td class="info">In the Environment Variables window, you will notice two sections, User variables for a username and System variables.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_env_sections.png" alt="Systems environment sections"/></td>
      </tr>
      <tr>
    <td class="info">To add <code>AF_PATH</code>, click on "New..." button in User variables section as shown.<br><br>
     Add <code>AF_PATH</code> in the "Variable name" field and ArrayFire directory <code>(C:\Users\accelereyes\arrayfire)</code> as the "Variable value".
     Click on "OK" to finalize the changes.<br><br>
        <td class="image"><img src="/content/images/installer/instructions_af_setpath.png" alt="Set environment variables"/></td>
      </tr>
      <tr>
        <td class="info"> Add the ArrayFire DLLs directory to your System "Path" Environment variable.<br><br>
        <strong>On Win 32-bit</strong>: <code>C:\Users\accelereyes\arrayfire\examples\bin_Win32</code>.<br>
        <strong>On Win 64-bit</strong>: <code>C:\Users\accelereyes\arrayfire\examples\bin_x64</code>.<br><br>
        Note the <strong>semi-colon</strong> after bin_Win32 which separates it from other values.
        <td class="image"><img src="/content/images/installer/instructions_af_add_to_path.png" alt="Adding ArrayFire DLLs to PATH"/></td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_4">
    <div class="header">Verifying CUDA</div>

    <table>
      <tr>
    <td class="info">NVIDIA CUDA toolkit sets <code>CUDA_INC_PATH, CUDA_BIN_PATH</code> and <code>CUDA_LIB_PATH</code> system environment
        variables during installation. Double-check and make sure these point correctly to CUDA <code>include, bin and lib</code> directories.
     Look for these environment variables in System variables section.
     </td>
        <td class="image"><img src="/content/images/installer/instructions_af_cudapath.png" alt="CUDA System environment variables"/></td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_5">
    <div class="header">Support</div>
    <table>
      <tr>
        <td>
          Online documentation for ArrayFire is available at <a href="http://www.accelereyes.com/arrayfire_cuda/"
          target="_blank">ArrayFire CUDA</a> page. 
          For additional assistance join the <a href="http://forums.accelereyes.com/forums/"
          target="_blank">ArrayFire Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_6">
    <div class="header">ArrayFire Licensing</div>
    <table>
      <tr>
       <td>
       By default, ArrayFire authenticates for free using hosted license servers at www.accelereyes.com.<br><br>
       <a href="http://www.accelereyes.com/products/arrayfire_licensing">ArrayFire Pro</a> adds several features not found in the free version,
       including the ability to run offline, <a href="http://www.accelereyes.com/arrayfire_cuda/group__device__mat.htm">run multiple devices in parallel</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__linalg__mat.htm">double-precision linear algebra</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__sparse__mat.htm">sparse linear algebra</a>, and more.
       Use the <a href="https://www.accelereyes.com/customer/account/login">Manage Licenses</a> page to start a Pro trial
       or download a purchased license file.<br>
       <br>Open the Windows Start Menu and select Run. Type <code>%HOME%</code> to open the directory where you save
       (<code>%HOMEPATH%</code> instead if <code>%HOME%</code> doesn't work) your downloaded license file (<code>%HOME%\arrayfire.lic</code>).
       <br><br>
       You can also save the license file to the same directory as your project executable.
       </td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_7">
    <div class="header">ArrayFire OpenCL Installation</div>
    <br>
    <table>
    <tr>
    <td class="info">ArrayFire OpenCL package contains the necessary OpenCL header files and DLLs to build and run ArrayFire and integrate with custom OpenCL projects.
     <br><br>
     Navigate to the examples directory and open any example in Visual Studio 2008.
     Choose an appropriate build mode from the menubar (e.g. <code>Release x64</code>), and select Run.<br><br>
     Online documentation for ArrayFire OpenCL is available at <a href="http://www.accelereyes.com/arrayfire_opencl/">ArrayFire OpenCL </a> page.
     <strong>Make sure you have installed the OpenCL drivers and SDK for your hardware (
     <a href="http://developer.amd.com/sdks/AMDAPPSDK/downloads/Pages/default.aspx">AMD</a>,
     <a href="http://software.intel.com/en-us/articles/vcsource-tools-opencl-sdk/">Intel</a> or <a href="http://developer.nvidia.com/cuda-downloads">NVIDIA</a>).
     Note that ArrayFire OpenCL is not compatible with Visual Studio 2010.
     </strong>
     </td>
     </tr>
    </table>
  </div>
  </div>

