<?php
   /**
   * Gets included in download_jacket.phtml if windows OS is detected.
   */
   ?>

<div class="download_instructions_container">

  <div class="header">Windows Installation Instructions</div>
  <div class="links">
     <a href="#section_1">Download and unzip</a> |
     <a href="#section_2">ArrayFire with Visual Studio</a> |
     <a href="#section_3">Setting AF_PATH Environment variable( Recommended )</a> |
     <a href="#section_4">Verifying CUDA Environment variables</a> |
     <a href="#section_5">ArrayFire Licensing and Additional Help</a>
  </div>

  <div class="section" id="section_1">
    <div class="header">Download and unzip the package</div>

    <table>
      <tr>
        <td>Click 'Save' when prompted by your browser.</td>
      </tr>
      <tr>
     <td>
     <br>
     When the download is complete, unzip the downloaded package
     choosing a destination directory, for example, <code>C:\Users\accelereyes</code>.
     After the extraction completes, you will see arrayfire directory created
     inside the destination directory <code>( C:\Users\accelereyes\arrayfire )</code>.
     </td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_2">
    <div class="header">Building ArrrayFire with Visual Studio</div>

    <table>
      <tr>
        <td class="info">ArrayFire ships with solution files for both Visual Studio 2008 and Visual Studio 2010.
        Navigate to the examples directory <code>( C:\Users\accelereyes\arrayfire\examples\ )</code> and open any example you
        would like to try out.
        <br>
        <br>
        The screenshot shows hello_world_vs2008.sln from examples\misc opened in Visual Studio 2008.
        Choose the configuration you want to build (Win32|x64, Debug|Release) and hit build and then run.
     </td>
        <td class="image"><img src="/content/images/installer/instructions_af_vs_2008.png" alt="Building ArrayFire examples"/></td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">Setting up environment variables for ArrayFire</div>
    <br>

    The step is not necessary but is recommended. <br> <br>
    This allows you to copy / move ArrayFire examples to any location outside the ArrayFire
    home directory <code>( C:\Users\accelereyes\arrayfire )</code> and build / run them. <br>

    In such cases, Visual Studio looks for AF_PATH to locate ArrayFire include directory and ArrayFire libraries
    ( libaf and libafGFX.lib ) and DLLs to link against. 
    <br>
    <br>

    <table>
      <tr>
        <td class="info">Right-click on "Computer" and select Properties.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_computer_properties.png" alt="Computer Properties"/></td>
      </tr>
      <tr>
        <td class="info">In the system window, click on "Advanced system settings" in the left panel.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_advanced_system_settings.png" alt="Advanced System Settings"/></td>
      </tr>
      <tr>
        <td class="info">In the System Properties window, select the "Advanced" tab and click on "Environment Variables" button
        given at the bottom of the window as highlighted in the red-box.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_systems_window.png" alt="Systems Window"/></td>
      </tr>
      <tr>
    <td class="info">In the Environment Variables window, you will notice two sections, User variables for a username and System variables.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_env_sections.png" alt="Systems environment sections"/></td>
      </tr>
      <tr>
    <td class="info">To add AF_PATH, click on "New..." button in User variables section as shown. Add AF_PATH in the "Variable name" field and
     ArrayFire home directory <code>( C:\Users\accelereyes\arrayfire )</code> as the "Variable value". Click on "OK" to finalize the changes.
     Note that adding AF_PATH to User variables section allows only current user to build ArrayFire examples outside Arrayfire home directory.
     To enable All users to build ArrayFire examples outside ArrayFire home directory, add AF_PATH to System variables section instead of User variables section.</td>
        <td class="image"><img src="/content/images/installer/instructions_af_setpath.png" alt="Set environment variables"/></td>
      </tr>
      <tr>
    <td class="info">Add <code>C:\Users\accelereyes\arrayfire\examples\bin_Win32</code> (On 32-bit Windows ) or
     <code>C:\Users\accelereyes\arrayfire\examples\bin_x64</code>( On 64-bit Windows ) to system "Path" variable in the System variables section
     as shown. Note the semi-colon after after bin_Win32 which separates it from other values. This step is necessary as the ArrayFire
    DLLs reside in this directory.
        <td class="image"><img src="/content/images/installer/instructions_af_add_to_path.png" alt="Adding ArrayFire DLLs to PATH"/></td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_4">
    <div class="header">Verifying CUDA environment variables set by NVIDIA CUDA Toolkit</div>

    <table>
      <tr>
    <td class="info">NVIDIA CUDA toolkit sets CUDA_INC_PATH, CUDA_BIN_PATH and CUDA_LIB_PATH system environment variables during installation.
     Double-check and make sure these point correctly to CUDA include/bin/lib directories. Look for these enviroment variables in System
     variables section as shown.
     </td>
        <td class="image"><img src="/content/images/installer/instructions_af_cudapath.png" alt="CUDA System environment variables"/></td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_5">
    <div class="header">ArrayFire Licensing and Additional Help</div>

    <table>
      <tr>
        <td>
          More details on ArrayFire licensing can be found at <a href="http://www.accelereyes.com/products/arrayfire_licensing"
          target="_blank">ArrayFire licensing page</a> 
          <br><br>
          Online documentation for ArrayFire is available at <a href="http://www.accelereyes.com/arrayfire_cuda/"
          target="_blank">ArrayFire CUDA</a> 
          For additional assistance join the <a href="http://forums.accelereyes.com/forums/"
          target="_blank">ArrayFire Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>
  </div>
  </div>