<?php
class Accelereyes_LicenseSystem_Model_Observer extends Mage_Core_Model_Abstract {
	/**
	* Record the license information for each product.
	*
	* @triggeredby: sales_order_place_after
	* @param $eventArgs array "order"=>$order
	*/
	public function recordLicenseForOrderEvent($observer) {
        error_log("I have been called.");
		$order = $observer->getEvent()->getOrder();
		$items =$order->getItemsCollection();

		//grab the customerId
		$customerId = Mage::getModel('customer/session')->getCustomerId();

		$_myGroupId = Mage::getSingleton('customer/session')->getCustomerGroupId();

		$_collection = Mage::getModel('customer/group')->getCollection();
	       foreach($_collection as $_group){
	       	$_g = $_group->toArray(array('customer_group_id', 'customer_group_code'));
	              $_groups[$_g['customer_group_id']] = $_g['customer_group_code'];
		}
		$_myGroupName = $_groups[$_myGroupId];

		$myType = 'commercial';

		if($_myGroupName=='Student'){
			$myType = 'student';
		} elseif($_myGroupName=='Academic') {
			$myType = 'academic';
		} elseif($_myGroupName=='Government / Research') {
			$myType = 'government';
		}

		foreach ($items as $_item) {
			$quantity = $_item->getQtyOrdered();
			for($i=0; $i<$quantity; $i++){
				$license = Mage::getModel('licensesystem/license');
				$itemSku = $_item->getSku();

				$month = date('m');
				$day = date('d');
				$year = date('Y');

				if(($itemSku == '002') || ($itemSku == '005')){
					$license->setMgo(2);
				}
				if(($itemSku == '003') || ($itemSku == '006')){
					$license->setMgo(3);
				}
				if(($itemSku == '004') || ($itemSku == '007')){
					$license->setMgo(4);
				}
				if(($itemSku == '002') || ($itemSku == '003') || ($itemSku == '004')){
					$license->setSupportDate(mktime(0,0,0,$month, $day, $year+1));
				}

				$license->setGfxToolbox(1);
				$license->setCustomerId($customerId);
				$license->setUserType($myType);
				$license->setPurchaseDate(mktime(0,0,0,$month, $day, $year));
				$license->setMaintenanceDate(mktime(0,0,0,$month, $day, $year+1));
				$license->setProductSku($_item->getSku());
                $license->setPaid(true);
				$license->save();
			}
		}
	}
}
