<?php

// the $customerId params laced throughout these functions are so sessionless code can still
// benefit from hidden/future versions
class Accelereyes_VersionLibjacket_Model_Version extends Mage_Core_Model_Abstract
{
    protected function _construct()
    {

        $this->_init('versionlibjacket/version');

    }

// Returns the appropriate file name to download for the specified version.
// Result depends entirely on the contents of the relevant row in the
// version table.  Older version use dates while newer versions use build #s.
public function getDownloadFileName($versionNumber, $platform){
    $filePrefix = "libJacket-";
    $fileSuffix = "";

    if ($platform == "mac" || $platform == "macintosh" || $platform == "osx"){
        $platform = "osx";
        $filePrefix .= "maci-";
        $fileSuffix = ".zip";
    }
    else if ($platform == "win" || $platform == "windows"){
        $platform = "windows";
        $filePrefix .= "win-";
	$fileSuffix = ".zip";
    }
    else if ($platform == "lin" || $platform = "linux"){
        $platform = "linux";
        $filePrefix .= "linux-";
        $fileSuffix = ".zip";
    }

    $filePrefix .= $versionNumber . "-";

    $collection = Mage::getModel('versionlibjacket/version')->getCollection()->toArray();
    foreach($collection['items'] as $ver){
        if($ver['version_number'] == $versionNumber){
            if ($ver[$platform . "_build"] == null || $ver[$platform ."_build"] == "" || $ver[$platform . "_build"] == 0){
                return $filePrefix . date("Ymd", $ver['date']) . $fileSuffix;
	    }
            else{
                return $filePrefix . $ver[$platform . "_build"] . $fileSuffix;
	    }
        }
    }

    return null;
}


    public function getCurrentVersionNumber($customerId = null)
    {
    	$collection = Mage::getModel('versionlibjacket/version')->getCollection()->toArray();
        $max = 0;
        $maxDate = 0;
        foreach($collection['items'] as $ver)
        {
	    if($ver['future_version'] > 0){
	      if (!$this->canSeeFutureVersions($customerId)) continue;
	    }	    

            if($ver['date'] > $maxDate)
            {

                $maxDate = $ver['date'];
                $max = $ver['version_number'];
            }

        }

        return $max;

    }

    /**
     * Returns true if the current customer can see future versions of jacket in
     * the website.  Must have an accelereyes.com email and be in the list of entity ids.
     */
    private function canSeeFutureVersions($customerId = null){ 
      // Some common customer ids to include:
      // 6324 = joe
      // 3218 = sandeep
      // 3151 = vish
      // 18 = john
      $allowed_customer_ids = array('3218','3151','18'); 

      if ($customerId != null) return in_array($customerId, $allowed_customer_ids);

      $customer = Mage::getSingleton('customer/session')->getCustomer();
      if ($customer != null){
      	 if ($customer->getEntityId() != null && $customer->getEmail() != null
	     && strlen($customer->getEntityId()) > 0){

	   if (!strpos($customer->getEmail(), "accelereyes.com")) return false;

	   if (in_array($customer->getEntityId(), $allowed_customer_ids)){
	     return true;
	   }
	 }
      }

      return false;
    }

    public function getCurrentVersionDate()
    {

	$collection = Mage::getModel('versionlibjacket/version')->getCollection()->toArray();
	$max=0;
	foreach($collection['items'] as $ver)
	{
	    if ($ver['future_version'] > 0){
	      if (!$this->canSeeFutureVersions()) continue;
	    }


	    if($ver['date'] > $max)
	    {

	        $max = $ver['date'];

	    }

	}

	return $max;

    }

    public function getVersionByNumber($version_number, $customerId = null)
    {

      	$collection = $this->getCollection()
            ->addFieldToFilter('version_number', $version_number)
            ->getData();

	if ($collection[0]['future_version'] > 0){
	  if (!$this->canSeeFutureVersions($customerId)) return null;
	}

        return $this->load($collection[0]['version_id']);

    }

    public function getVersionsArray()
    {
        $allowed_collection = array();

        $collection = Mage::getModel('versionlibjacket/version')->getCollection()->toArray();

	foreach($collection['items'] as $version){
	  if ($version['future_version'] > 0){
	    if (!$this->canSeeFutureVersions()) continue;
	  }

	  $allowed_collection[] = $version;
	}

	return $allowed_collection;
    }

    public function getVersionNamesArray()
    {

        $collection = Mage::getModel('versionlibjacket/version')->getCollection()->toArray();
        $names = array();
        foreach($collection['items'] as $version)
        {
	    if ($version['future_version'] > 0){
	      if (!$this->canSeeFutureVersions()) continue;
	    }

            $names[] = $version['version_number'];
        }

        return $names;

    }

}
