<?php

class Accelereyes_VersionLibjacket_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('versionGrid');
        $this->_controller = 'versionlibjacket';

    }

    protected function _prepareCollection()
    {

        $model = Mage::getModel('versionlibjacket/version');
        $collection = $model->getCollection();
        $this->setCollection($collection);

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('version_number', array(
            'header'        => Mage::helper('versionlibjacket')->__('Version Number'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'version_number',
            'index'         => 'version_number',
        ));

        $this->addColumn('date', array(
            'header'        => Mage::helper('versionlibjacket')->__('Date'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'date',
            'index'         => 'date',
        ));

        $this->addColumn('windows_build', array(
            'header'        => Mage::helper('versionlibjacket')->__('Windows Build'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'windows_build',
            'index'         => 'windows_build',
        ));

        $this->addColumn('linux_build', array(
            'header'        => Mage::helper('versionlibjacket')->__('Linux Build'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'linux_build',
            'index'         => 'linux_build',
        ));

        $this->addColumn('osx_build', array(
            'header'        => Mage::helper('versionlibjacket')->__('OS X Build'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'osx_build',
            'index'         => 'osx_build',
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('versionlibjacket')->__('Action'),
                'width'     => '25px',
                'type'      => 'action',
                'getter'    => 'getVersionId',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('versionlibjacket')->__('Edit'),
                        'url'       => array(
                            'base'  => '*/*/edit'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('versionlibjacket')->__('Delete'),
                        'url'       => array(
                            'base'  => '*/*/delete'
                        ),
                        'field'     => 'id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false
            )
        );

        return parent::_prepareColumns();

    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/edit', array('id' => $row->getVersionId()));

    }

}
