<?php
/**
 * A subclass for the core Subscriber class that simply calls the parent when subscription
 * status changes and dispatches an event so that other modules can hook on additional
 * logic.
 *
 * The events fired are:
 *   - custom_event_subscribe
 *   - custom_event_unsubscribe
 *
 * An email gets attached to the dispatched event for usage by the Observer.
 */
class Accelereyes_Subscriber_Model_Subscriber extends Mage_Newsletter_Model_Subscriber {

    /**
     * Called for subscribes where customer is unknown
     */
    public function subscribe($email){
        Mage::dispatchEvent('custom_event_subscribe', array('email' => $email));
    
        return parent::subscribe($email);
    }

    /**
     * Called for unsubscribes where customer is unknown
     */
    public function unsubscribe(){
        Mage::dispatchEvent('custom_event_unsubscribe', array('email' => $this->getSubscriberEmail()));

        return parent::unsubscribe();
    }

    /**
     * Called when a customer subscribes/unsubscribes.  
     */
    public function subscribeCustomer($customer){
        parent::subscribeCustomer($customer);

        if ($this->getStatus() == 1){
            if ($this->getIsStatusChanged())
                Mage::dispatchEvent('custom_event_subscribe', array('email' => $customer->getEmail()));
        }
        else{
            if ($this->getIsStatusChanged())
                Mage::dispatchEvent('custom_event_unsubscribe', array('email' => $customer->getEmail()));
        }
    }
}
?>