<?php
class Accelereyes_Salesrep_AdminController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {

        $this->loadLayout()
                ->_addContent($this->getLayout()->createBlock('salesrep/admin_main'))
                ->renderLayout();

    }

    public function deleteAction()
    {

        $salesrepId = $this->getRequest()->getParam('id', false);

        try {

            Mage::getModel('salesrep/salesrep')->setId($salesrepId)->delete();
            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('salesrep')->__('Sales
                Rep deleted successfully.'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));

            return;

        } catch (Exception $e) {

            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

        }

        $this->_redirectReferer();

    }

    public function newAction()
    {

        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('salesrep/admin_new'))
            ->renderLayout();

    }

    public function postAction()
    {

        if ($data = $this->getRequest()->getPost()) {
            $salesrep = Mage::getModel('salesrep/salesrep')->setData($data);
            try {
                $salesrep->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('salesrep')->__('Sales Rep created successfully.'));
                $this->getResponse()->setRedirect($this->getUrl('*/*/'));

                return;

            } catch (Exception $e) {

                die($e->getMessage());
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

       }

       $this->getResponse()->setRedirect($this->getUrl('*/*/'));
       return;

    }

    public function editAction()
    {

        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('salesrep/admin_edit'));
        $this->renderLayout();

    }

    public function saveAction()
    {

        $salesrepId = $this->getRequest()->getParam('id', false);
        if ($data = $this->getRequest()->getPost()) {

            $salesrep = Mage::getModel('salesrep/salesrep')->load($salesrepId)->addData($data);
            try {
                $salesrep->setId($salesrepId)->save();

                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('salesrep')->__('Sales
                    Rep updated successfully.'));
                $this->getResponse()->setRedirect($this->getUrl('*/*/'));

                return;

            } catch (Exception $e) {

                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

        }

        $this->_redirectReferer();

    }

}
