<?php

class Accelereyes_Salesrep_Block_Admin_New_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $form = new Varien_Data_Form();

        $fieldset = $form->addFieldset('new_salesrep', array('legend' => Mage::helper('salesrep')->__('New Sales Rep')));

        $fieldset->addField('name', 'text', array(
            'name'      => 'name',
            'title'     => Mage::helper('salesrep')->__('Name'),
            'label'     => Mage::helper('salesrep')->__('Name'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('company', 'select', array(
            'name'      => 'company',
            'title'     => Mage::helper('salesrep')->__('Company'),
            'label'     => Mage::helper('salesrep')->__('Company'),
            'options'   => $this->_getCompaniesArray(),
            'required'  => true,
        ));

        $fieldset->addField('address', 'text', array(
            'name'      => 'address',
            'title'     => Mage::helper('salesrep')->__('Address'),
            'label'     => Mage::helper('salesrep')->__('Address'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('phone', 'text', array(
            'name'      => 'phone',
            'title'     => Mage::helper('salesrep')->__('Phone'),
            'label'     => Mage::helper('salesrep')->__('Phone'),
            'maxlength' => '50',
            'required'  => true,
        ));

        $fieldset->addField('customer_id', 'text', array(
            'name'      => 'customer_id',
            'title'     => Mage::helper('salesrep')->__('Customer ID'),
            'label'     => Mage::helper('salesrep')->__('Customer ID'),
            'maxlength' => '50',
            'required'  => false,
        ));

        $form->setMethod('post');
        $form->setUseContainer(true);
        $form->setId('edit_form');
        $form->setAction($this->getUrl('*/*/post'));

        $this->setForm($form);

    }

    protected function _getCompaniesArray()
    {

        $companies = Mage::getModel('reseller/reseller')->getCollection();
        $result = array();
        foreach ($companies as $id => $company) {
            $result[$company->getCompany()] = $company->getCompany();
        }
        return $result;

    }

}
