<?php

class Accelereyes_Salesrep_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('salesrepGrid');
        $this->_controller = 'salesrep';

    }

    protected function _prepareCollection()
    {

        $model = Mage::getModel('salesrep/salesrep');
        $collection = $model->getCollection();
        $this->setCollection($collection);

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('salesrep_id', array(
            'header'        => Mage::helper('salesrep')->__('ID'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'salesrep_id',
            'index'         => 'salesrep_id',
        ));

        $this->addColumn('name', array(
            'header'        => Mage::helper('salesrep')->__('Name'),
            'align'         => 'left',
            'width'         => '50px',
            'filter_index'  => 'name',
            'index'         => 'name',
            'type'          => 'text',
            'truncate'      => 50,
            'escape'        => true,
        ));

        $this->addColumn('company', array(
            'header'        => Mage::helper('salesrep')->__('Company'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'company',
            'index'         => 'company',
            'escape'        => true,
        ));

        $this->addColumn('address', array(
            'header'        => Mage::helper('salesrep')->__('Address'),
            'align'         => 'right',
            'width'         => '150px',
            'filter_index'  => 'address',
            'index'         => 'address',
            'escape'        => true,
        ));

        $this->addColumn('phone', array(
            'header'        => Mage::helper('salesrep')->__('Phone'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'phone',
            'index'         => 'phone',
            'escape'        => true,
        ));

        $this->addColumn('customer_id', array(
            'header'        => Mage::helper('salesrep')->__('Customer ID'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'customer_id',
            'index'         => 'customer_id',
            'escape'        => true,
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('salesrep')->__('Action'),
                'width'     => '25px',
                'type'      => 'action',
                'getter'    => 'getSalesrepId',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('salesrep')->__('Edit'),
                        'url'       => array(
                            'base'  => '*/*/edit'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('salesrep')->__('Delete'),
                        'url'       => array(
                            'base'  => '*/*/delete'
                        ),
                        'field'     => 'id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false
            )
        );

        return parent::_prepareColumns();

    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/edit', array('id' => $row->getSalesrepId()));

    }

}
