<?php
/**
 * For full Magento objects this Observer should be used for all SalesForce
 * synchronization.  
 */

require_once('/var/www/common_libraries/soapclient/SforceEnterpriseClient.php');
require_once('/var/www/common_libraries/soapclient/SforceHeaderOptions.php');
require_once('CustomFunctions.php');

class Accelereyes_SalesForce_Observer{

    // salesforce account and authentication information
    const SALESFORCE_USER = 'john.melonakos@accelereyes.com';
    const SALESFORCE_PASS = 's311m0r32day!';
    const SALESFORCE_TOKEN = 'y7KgV4W7QKE40nXIZ03c2cD3B';

    const SALESFORCE_WSDL = '/var/www/common_libraries/soapclient/enterprise.wsdl.xml';
    const DEFAULT_OWNER_ID = '005A0000000YzSx';
    const DEFAULT_LEAD_OWNER_ID = '00GA0000000iSPD';

    /* const SF_SALES_NOTICE_EMAIL = 'krunal.patel@accelereyes.com'; */
    const SF_SALES_NOTICE_EMAIL = 'sales@accelereyes.com';
  
    // leads sources (matching salesforce) for various events in the class
    const LEAD_SOURCE_PRODUCT_INTEREST_JACKET = 'Website Register - Jacket';
    const LEAD_SOURCE_PRODUCT_INTEREST_LIBJACKET = 'Website Register - ArrayFire';
    const LEAD_SOURCE_PRODUCT_INTEREST_BOTH = 'Website Register - Both';
    const LEAD_SOURCE_TRIAL = 'Jacket Trial Download';
    const LEAD_SOURCE_ARRAYFIRE_PRO_TRIAL = 'ArrayFire Pro Trial Download';
    const LEAD_SOURCE_SUBSCRIBE = "Newsletter Subscription";
    const LEAD_SOURCE_HOSTID = "Host ID Change";
    const LEAD_SOURCE_LENOVO_PROMO = 'Lenovo Promo';
    const LEAD_CONTACT_US = "Inbound Email/Web Form";
    const LEAD_SOURCE_ARRAYFIRE_DOWNLOAD = 'ArrayFire Download';
    const LEAD_SOURCE_CONSULTING_INQUIRY = 'Consulting Inquiry';
    const LEAD_SOURCE_ARRAYFIRE_DEPLOY_INQUIRY = "ArrayFire Deploy Inquiry";
    const LEAD_SOURCE_WHITEPAPER_DOWNLOAD = 'Whitepaper Download';

    public function __construct(){}

    /**
     * Configured to fire for customer_save_after events.  These represent new customers
     * that need to be synced to SalesForce.  Update existing SF record if already exists.
     * Note that customer_save_after fires in several scenarios so it must be flexible.
     *   - When creating an account
     *   - When updating account information
     *   - When placing an order
     */
    public function updateCustomer($observer){
        try {

            error_log(date("Y-m-d H:i:s") . ": Entered Observer.php\n",3,'/var/www/magento_sandbox/error_log');

            //http://stackoverflow.com/questions/5838346/magento-customer-save-after-always-fired-twice
            if(Mage::registry('customer_save_observer_executed')){
                return;
            }        

            $event = $observer->getEvent();
            $salesForceClient = $this->getSalesForceClient();

            $leadObject = self::createLeadData($event);
            $leadObject->Customer_Since__c = date("Y-m-d");

            $customerId = self::getCustomerId($event);

            $customer = $event->getCustomer();
            $lspi = self::LEAD_SOURCE_PRODUCT_INTEREST_BOTH;

            if ($customer->getLenovoPromoCode() != null)
            {
                if ($customer->getConfirmation()) { 
                    //we only want to do the following when a user is created, we checked all the net
                    //to figure this out best in Magento, but since its a piece of crap, we found this
                    //workaround that guaratees us that this will only be called once when an user is create
                    $to = 'sales@accelereyes.com';
                    $subject = 'Jacket Lenovo Promotion Request (New User)';
                    $customer_addr = $customer->getEmail();
                    $body = 'Lenovo Promotion: ' . $customer->getLenovoPromoCode() . ' requested from: '. $customer_addr. ' with serial number: ' . $customer->getLenovoSerialNumber() . ' and model: '. $customer->getLenovoModel();
                    $header = 'From: AccelerEyes <sales@accelereyes.com>' . "\r\n";
                    ini_set('sendmail_from', 'sales@accelereyes.com');
                    mail($to, $subject, $body, $header);
              
                    //also need to notify SF
                    $leadObject->Lenovo_Model__c = $customer->getLenovoModel();
                    $leadObject->Lenovo_Promo_Code__c = $customer->getLenovoPromoCode();
                    $leadObject->Lenovo_Serial_Number__c = $customer->getLenovoSerialNumber();
                }
            }

            if ($customer->getProductInterest() == "Jacket")
            {
                $lspi = self::LEAD_SOURCE_PRODUCT_INTEREST_JACKET;
            } elseif ($customer->getProductInterest() == "LibJacket")
                {
                    $lspi = self::LEAD_SOURCE_PRODUCT_INTEREST_LIBJACKET;
                }

            $leadId = $this->createOrUpdateLead($salesForceClient, $leadObject, $lspi, $customerId);

            if ($leadId != null){
                $this->activityCreate($salesForceClient, $leadId, 'Account Created', 'Customer Account created.', $lspi, $customerId);
                error_log(date("Y-m-d H:i:s") . ": Customer Account Created",3,'/var/www/magento_sandbox/error_log');
            }

            Mage::register('customer_save_observer_executed',true);

        } catch(Exception $e){
            error_log(print_r($e->getMessage(),true));
            error_log(print_r($e->getMessage(),true),3,'/var/www/magento_sandbox/error_log');
            self::sendSalesForceFailureNotice("Exception caught while updating customer " . $event->getCustomer()->getEmail() . " in Magento SalesForce Observer.\n\n" . $e->getMessage());
        }
    }

    /**
     * Fires for host_id_changed events that get kicked off by licensing pages
     */
    public function hostIdChanged($observer){
        try{
            $licenseNumber = $observer->getEvent()->getLicenseNumber();
            $oldId = $observer->getEvent()->getOldId();
            $newId = $observer->getEvent()->getNewId();

            $email = $observer->getEvent()->getCustomer()->getEmail();
            $client = $this->getSalesForceClient();
            $customerId = self::getCustomerId($observer->getEvent());
            $leadObject = self::createLeadData($observer->getEvent());

            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_HOSTID, $customerId);
      
            if ($leadId != null){
                $url = "Unknown";
                $request = Mage::app()->getRequest();
                if ($request != null && $request->getServer('HTTP_REFERER') != null){
                    $url = $request->getServer('HTTP_REFERER');
                }

                $this->activityCreate($client, $leadId, 'Host ID Change [lic# ' . $licenseNumber . ']: ' . $oldId . " changed to " . $newId, 'Changed License HostID ' . $url . '.', self::LEAD_SOURCE_HOSTID, $customerId);
            }
        }
        catch(Exception $e){
            error_log(print_f($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when syncing customer " . $email . " host id change to salesforce.\n\n" . $e->getMessage());
        }   
    }  

    /**
     * Fires for custom_event_subscribe events that get fired by our overriding 
     * subclass of Subscriber.php
     */
    public function subscribeEmail($observer){
        try{
            $client = $this->getSalesForceClient();
            $email = $observer->getEvent()->getEmail();

            $customerId = "";
            $leadObject = null;
            
            if (Mage::getSingleton('customer/session')->isLoggedIn())
            {
                $customer = Mage::getSingleton('customer/session')->getCustomer();
                $leadObject = self::createLeadData(null,$customer);
            } else
            {
                $leadObject = self::createEmailOnlyLeadData($email);
            }

            $leadObject->HasOptedOutOfEmail = false;

            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_SUBSCRIBE, $customerId);
      
            if ($leadId != null)
            {
                $url = "Unknown";
                $request = Mage::app()->getRequest();
                if ($request != null && $request->getServer('HTTP_REFERER') != null)
                {
                    $url = $request->getServer('HTTP_REFERER');
                }

                $this->activityCreate($client, $leadId, 'Subscribed to Newsletter', 'Subscribed to Newsletter on page ' . $url . '.', self::LEAD_SOURCE_SUBSCRIBE, $customerId);
            }

        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when subscribing new email for customer ". $email ." in SalesForce Observer.\n\n"
                                              . $e->getMessage());
        }
    }

    /**
     * Fires for custom_event_unsubscribe events that get fired by our overriding
     * subclass of Subscriber.php
     */
    public function unsubscribeEmail($observer){
        try{
            $client = $this->getSalesForceClient();
            $email = $observer->getEvent()->getEmail();

            $customerId = "";
            $leadObject = null;
            
            if (Mage::getSingleton('customer/session')->isLoggedIn())
            {
                $customer = Mage::getSingleton('customer/session')->getCustomer();
                $leadObject = self::createLeadData(null,$customer);
            } else
            {
                $leadObject = self::createEmailOnlyLeadData($email);
            }

            $leadObject->HasOptedOutOfEmail = true;

            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_SUBSCRIBE, $customerId);

            if ($leadId != null)
            {
                $this->activityCreate($client, $leadId, "Unsubscribed from Newsletter", "Unsubscribed from Newsletter.",
                                      self::LEAD_SOURCE_SUBSCRIBE, $customerId, false);
            }

        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when unsubscribing email for customer " . $email . "in SalesForce Observer.\n\n"
                                              . $e->getMessage());
        }
    }

    public function lenovoPromoLead($observer)
    {
        try{
            $eventData = $observer->getEvent()->getEventdata();

            $first_name = $eventData['first_name'];
            $last_name = $eventData['last_name'];
            $email = $eventData['email'];
            $lenovo_promo_code = $eventData['lenovo_promo_code'];
            $newsletter = $eventData['newsletter'];

            $client = $this->getSalesForceClient();

            $leadObject = new StdClass;
            $leadObject->FirstName = $first_name;
            $leadObject->LastName = $last_name;
            $leadObject->Company = "Unknown";   // required field on the salesforce end
            $leadObject->Email = $email;
            $leadObject->HasOptedOutOfEmail = ($newsletter) ? false : true;
            $leadObject->Lenovo_Promo_Code__c = $lenovo_promo_code;

            $customerId = "";
            $customerModel = Mage::getModel('customer/customer');
            $customerModel->setWebsiteId(Mage::app()->getWebsite()->getId());
            $customer = $customerModel->loadByEmail($email);
            if ($customer != null){
                $customerId = $customer->getId();
            }           	
      
            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_LENOVO_PROMO, $customerId);
      
            if ($leadId != null) {
                $this->activityCreate($client, $leadId, 'Lenovo Promo (New Potential User)', 'New potential user utilized Lenvo promo: '.$lenovo_promo_code, self::LEAD_SOURCE_LENOVO_PROMO, $customerId);
            }

        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when creating lenovo promo for customer " . $email . "  lead.\n\n" . $e->getMessage());
        }   
    }

    public function lenovoPromoUpdate($observer)
    {
        try{
            $client = $this->getSalesForceClient();
            $leadObject = self::createLeadData($observer->getEvent());
            $customerId = self::getCustomerId($observer->getEvent());
            $customer = $observer->getEvent()->getCustomer();

            $leadObject = self::createLeadData($observer->getEvent());
            $leadObject->Lenovo_Model__c = $customer->getLenovoModel();
            $leadObject->Lenovo_Promo_Code__c = $customer->getLenovoPromoCode();
            $leadObject->Lenovo_Serial_Number__c = $customer->getLenovoSerialNumber();

            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_LENOVO_PROMO, $customerId);

            if ($leadId != null) {
                $this->activityCreate($client, $leadId, 'Lenovo Promo (Existing User)', 'Existing user utilized Lenvo promo: '.$customer->getLenovoPromoCode(), self::LEAD_SOURCE_LENOVO_PROMO, $customerId);
            }
        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when updating lenovo promo for customer " . $observer->getEvent()->getCustomer()->getEmail() . " .\n\n" . $e->getMessage());
        }   
    }

    public function contactUs($observer)
    {
        try{
            $email = $observer->getEvent()->getEmail();
            $first_name = $observer->getEvent()->getFirstName();
            $last_name = $observer->getEvent()->getLastName();
            $description = $observer->getEvent()->getDescription();
            $company = $observer->getEvent()->getCompany();
            $country = $observer->getEvent()->getCountry();

            $client = $this->getSalesForceClient();

            $leadObject = new StdClass;
            $leadObject->FirstName = $first_name;
            $leadObject->LastName = $last_name;
            $leadObject->Company = $company;   
            $leadObject->Email = $email;
            $leadObject->Country = $country;

            $customerId = "";
            $customerModel = Mage::getModel('customer/customer');
            $customerModel->setWebsiteId(Mage::app()->getWebsite()->getId());
            $customer = $customerModel->loadByEmail($email);
            if ($customer != null){
                $customerId = $customer->getId();
            }
      
            $leadId = $this->createOrUpdateLead($client, $leadObject, self::LEAD_CONTACT_US, $customerId);
      
            if ($leadId != null)
            {
                $body = "*** NEW LEAD ASSIGNMENT NOTIFICATION ***\n\nThe following lead has been assigned to you.\nCompany: " . $company . "\nCountry: " . $country . "\nLead Name: " . $first_name . " " . $last_name . "\nComments:\n" . $description;
                $this->activityCreate($client, $leadId, 'Contact Us', $body, self::LEAD_CONTACT_US, $customerId, true, true);          
            }

        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught during contact us for customer " . $email . " in SalesForce Observer.\n\n" . $e->getMessage());
        }      
    }

    /**
     * Configured to fire for begin_trial events.  Logs activity to the lead in SalesForce
     * and notifies AccelerEyes sales staff.
     */
    public function trialCustomer($observer){
        try 
        {
            if ($observer->getEvent()->getBaseproduct() == "libjacket")
            {
                $baseproduct = "ArrayFire Pro";
            } else
            {
                $baseproduct = "Jacket";
            }

            $email = $observer->getEvent()->getCustomer()->getEmail();
            $client = $this->getSalesForceClient();

            $customerId = self::getCustomerId($observer->getEvent());

            $leadObject = self::createLeadData($observer->getEvent());

            $ls = null;
            if ($baseproduct == "Jacket")
            {
                //update the state variable to indicate that we are starting a jacket trial
                $leadObject->Jacket_Trial_Start__c = date("Y-m-d");
                $ls = self::LEAD_SOURCE_TRIAL;
            } else
            {
                $leadObject->ArrayFire_Pro_Trial_Start__c = date("Y-m-d");
                $ls = self::LEAD_SOURCE_ARRAYFIRE_PRO_TRIAL;
            }
            
            $coul = $this->createOrUpdateLead($client, $leadObject, $ls, $customerId);

            if ($coul != null)
            {
                list($leadId, $table_name) = $coul;
                $this->activityCreate($client, $coul, $baseproduct . " Trial Activity", "User has started a " . $baseproduct  ." trial.", $ls, $customerId);
            }
            else 
            {
                self::sendSalesForceFailureNotice("Unable to find a SalesForce record for trial activity for '" . $email . "'");
            }
        }
        catch(Exception $e){
            error_log(substr(print_r($e, true),0,2000));
            self::sendSalesForceFailureNotice("Unable to find a SalesForce record for trial activity for '" . $email . "'");
        }
    }

    public function customerLogin($observer)
    {
        try{
            $email = $observer->getEvent()->getCustomer()->getEmail();
            $client = $this->getSalesForceClient();
            $leadObject = self::createLeadData($observer->getEvent());

            $customerId = "";
            $customerModel = Mage::getModel('customer/customer');
            $customerModel->setWebsiteId(Mage::app()->getWebsite()->getId());
            $customer = $customerModel->loadByEmail($email);
            if ($customer != null){
                $customerId = $customer->getId();
            }
      
            $leadId = $this->createOrUpdateLead($client, $leadObject, null, $customerId);
 
            //ok check if we need to register/create a license per API
            //CustomFunctions::registerCreateLicense();
        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when customer " . $email ."  login in SalesForce Observer.\n\n"
                                              . $e->getMessage());
        }
    }

    public function arrayfireDownload($observer)
    {
        try{
            $email = $observer->getEvent()->getEmail();
            $first_name = $observer->getEvent()->getFirstName();
            $last_name = $observer->getEvent()->getLastName();
            $desc = $observer->getEvent()->getDescription();
            $company = $observer->getEvent()->getCompany();
            $phone = $observer->getEvent()->getPhone();
            $send_email = $observer->getEvent()->getSendEmail();
            $args = array($first_name, $last_name, $email, $company, $phone, $desc);
            $this->registerUser($args, self::LEAD_SOURCE_ARRAYFIRE_DOWNLOAD);

            $sender = array('name' => 'AccelerEyes',
                            'email' => 'sales@accelereyes.com');
            $vars = array('customerName' => $first_name . ' ' . $last_name);

            if ($send_email)
            {
                //notice we hardcode the id here cause we couldn't figure out how to cange the core_config table to contain this
                //this is fine since the live DB has the same id
                Mage::getModel('core/email_template')
                    ->sendTransactional(
                        22,
                        $sender,
                        $email,
                        $first_name . ' ' . $last_name,
                        $vars
                        );
            }
        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when ArrayFire download for customer " . $email . " SalesForce Observer.\n\n". $e->getMessage());
        }
    }

    public function consultingServicesInquiry($observer)
    {
        try{
            $email = $observer->getEvent()->getEmail();
            $first_name = $observer->getEvent()->getFirstName();
            $last_name = $observer->getEvent()->getLastName();
            $desc = $observer->getEvent()->getDescription();
            $company = $observer->getEvent()->getCompany();
            $phone = $observer->getEvent()->getPhone();
            $args = array($first_name, $last_name, $email, $company, $phone, $desc);
            $this->registerUser($args, self::LEAD_SOURCE_CONSULTING_INQUIRY);

            $sender = array('name' => 'AccelerEyes',
                            'email' => 'sales@accelereyes.com');
            $vars = array('customerName' => $first_name . ' ' . $last_name, 'company'=>$company, 'details'=>$desc);

            //notice we hardcode the id here cause we couldn't figure out how to cange the core_config table to contain this
            //this is fine since the live DB has the same id
            Mage::getModel('core/email_template')
                ->sendTransactional(
                    23,
                    $sender,
                    $email,
                    $first_name . ' ' . $last_name,
                    $vars
                    );
        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when consulting services inquiry for customer " . $email . " SalesForce Observer.\n\n". $e->getMessage());
        }
    }

    public function arrayfireDeployInquiry($observer)
    {
        try{
            $email = $observer->getEvent()->getEmail();
            $first_name = $observer->getEvent()->getFirstName();
            $last_name = $observer->getEvent()->getLastName();
            $desc = $observer->getEvent()->getDescription();
            $company = $observer->getEvent()->getCompany();
            $phone = $observer->getEvent()->getPhone();
            $args = array($first_name, $last_name, $email, $company, $phone, $desc);
            $this->registerUser($args, self::LEAD_SOURCE_ARRAYFIRE_DEPLOY_INQUIRY);

            $sender = array('name' => 'AccelerEyes',
                            'email' => 'sales@accelereyes.com');
            $vars = array('customerName' => $first_name . ' ' . $last_name, 'company'=>$company, 'details'=>$desc);

            //notice we hardcode the id here cause we couldn't figure out how to cange the core_config table to contain this
            //this is fine since the live DB has the same id
            Mage::getModel('core/email_template')
                ->sendTransactional(
                    24,
                    $sender,
                    $email,
                    $first_name . ' ' . $last_name,
                    $vars
                    );
        }
        catch(Exception $e){
            error_log(print_r($e->getMessage(), true));
            self::sendSalesForceFailureNotice("Exception caught when arrayfire deploy inquiry for customer " . $email . " SalesForce Observer.\n\n". $e->getMessage());
        }
    }

    private function registerUser($args,$ls)
    {
        list($firstName, $lastName, $email, $company, $phone, $desc) = $args;

        $client = $this->getSalesForceClient();
        $leadObject = new StdClass;
        $leadObject->FirstName = $firstName;
        $leadObject->LastName = $lastName;
        $leadObject->Email = $email;
        $leadObject->Company = $company;
        $leadObject->Phone = $phone;
        $leadObject->Description = $desc;

        //some special logic
        if ($ls == self::LEAD_SOURCE_ARRAYFIRE_DOWNLOAD)
        {
            //if we are downloading arrayfire, mark the date
            $leadObject->ArrayFire_Download_Date__c = date("Y-m-d");
        }

        if ($ls == self::LEAD_SOURCE_CONSULTING_INQUIRY)
        {
            $leadObject->Consulting_Inquiry_Date__c = date("Y-m-d");
        }

        if ($ls == self::LEAD_SOURCE_ARRAYFIRE_DEPLOY_INQUIRY)
        {
            $leadObject->ArrayFire_Deploy_Inquiry_Date__c = date("Y-m-d");
        }

        $customerId = "";
        $customerModel = Mage::getModel('customer/customer');
        $customerModel->setWebsiteId(Mage::app()->getWebsite()->getId());
        $customer = $customerModel->loadByEmail($email);
        if ($customer != null){
            $customerId = $customer->getId();
        }

        $leadId = $this->createOrUpdateLead($client, $leadObject, $ls, $customerId);
      
        if ($leadId != null)
        {
            $this->activityCreate($client, $leadId, $ls, "Company: " . $company . "\nName: " . $firstName . " " . $lastName . "\nEmail: " . $email . "\nDescription: " . $desc, $ls,$customerId, true, true);
        }
    }

    public function whitepaperDownload($observer)
    {
        try 
        {
            $sf = $observer->getEvent()->getSf();
            $furl = $observer->getEvent()->getFurl();
            $email = $observer->getEvent()->getCustomer()->getEmail();
            $client = $this->getSalesForceClient();
            $customerId = self::getCustomerId($observer->getEvent());
            $leadObject = self::createLeadData($observer->getEvent());
            $leadObject->$sf = date("Y-m-d");
            $coul = $this->createOrUpdateLead($client, $leadObject, self::LEAD_SOURCE_WHITEPAPER_DOWNLOAD, $customerId);

            if ($coul != null)
            {
                list($leadId, $table_name) = $coul;
                $this->activityCreate($client, $coul, "Whitepaper Download Activity", "User has downloaded whitepaper " . $furl  .".", self::LEAD_SOURCE_WHITEPAPER_DOWNLOAD, $customerId, true, true);
            }
            else 
            {
                self::sendSalesForceFailureNotice("Unable to find a SalesForce record for whitepaper download activity for '" . $email . "'");
            }
        }
        catch(Exception $e){
            error_log(substr(print_r($e, true),0,2000));
            self::sendSalesForceFailureNotice("Unable to find a SalesForce record for whitepaper download activity for '" . $email . "'");
        }
    }

    /**
     * Creates a salesforce client and authenticates it.
     * @return An authenticated client or null if connection errors.
     */
    private function getSalesForceClient(){
        try {
            $client = new SforceEnterpriseClient();
            $client->createConnection(self::SALESFORCE_WSDL);

            $loginResult = $client->login(self::SALESFORCE_USER, self::SALESFORCE_PASS . self::SALESFORCE_TOKEN);
            if (!$loginResult){
                return self::sendSalesForceFailureNotice("Unable to login to SalesForce account in Magento Observer.");
            }
      
            return $client;
        }
        catch(Exception $e){
            error_log(substr(print_r($e, true),0,2000));
        }    
    }

    /**
     * Creates an activity record in SalesForce for the specified lead.
     */
    private function activityCreate($client, $leadIdArr, $subject, $description, $leadSource, $customerId, $sendSalesNotification = true, $emailDescription=false){
        ini_set('soap.wsdl_cache_enabled', 0);
      
        //ok $leadIdArr is an array of (leadid, tablename)
        list($leadId, $table_name,$isNew) = $leadIdArr;

        if ($leadId == null || empty($leadId))
        {
            return;
        }

        $description = "***" . ($isNew ? ' NEW ' : ' EXISTING ') . $table_name . " ASSIGNMENT NOTIFICATION ***\n\nThe following " . $table_name  . " has been assigned to you.\n\n" . $description;

        $leadResult = $client->query("SELECT Id, Email, " . (($table_name=='Lead') ? 'Company, ' : '')  . "FirstName, LastName, Phone FROM ". $table_name ."  WHERE Id = '" . $leadId . "'" . (($table_name=='Lead') ? ' AND IsConverted <> true' : ''));

        if (self::resultCount($leadResult) != 1)
        {
            if (self::resultCount($leadResult) == 0)
            {
                return;
            } else
            {
                return self::sendSalesForceFailureNotice("Duplicate leads/contacts found when attempting to push activity for id: " . $leadId);
            }
        }

        // Verifying that not already a task for this lead with same subject.  Magento fires the customer_save_after
        // event in many different scenarios and sometimes will fire it multiple times for a single event.  This 
        // prevent duplication on the SalesForce side.  Only care about this for certain lead sources.
        if ($leadSource != self::LEAD_SOURCE_CONSULTING_INQUIRY && $leadSource != self::LEAD_SOURCE_ARRAYFIRE_DEPLOY_INQUIRY && $leadSource != self::LEAD_SOURCE_WHITEPAPER_DOWNLOAD && $leadSource != self::LEAD_SOURCE_TRIAL && $leadSource != self::LEAD_SOURCE_SUBSCRIBE && $leadSource != self::LEAD_CONTACT_US)
        {
            $taskDupeResult = $client->query ("SELECT Who.Id FROM Task WHERE Who.Id = '" . $leadId . "' AND Subject = '" . $subject . "'");
            if (self::resultCount($taskDupeResult) > 0)
            {
                return;
            }
        }

        $leadObject = $leadResult->records[0];
      
        $task = new StdClass;
        $task->WhoID = $leadId;
        $task->Description = $description;
        $task->Status = 'Completed';
        $task->Subject = $subject;
        $task->OwnerID = self::DEFAULT_OWNER_ID;
        $task->ActivityDate = date("Y-m-d");
        $task->ipaddress__c = (!empty($_SERVER['REMOTE_ADDR']))? $_SERVER['REMOTE_ADDR'] : "Unknown";

        $customLink = Mage::getSingleton('core/resource')->getConnection('core_read');
        $customLink->query("INSERT INTO log_activities (customer_id, activity_desc, ip_Address) "
                           . "VALUES ('". $customerId . "','" . $subject . "','" . $task->ipaddress__c . "')");

        $client->create(array($task), "Task");

        if ($sendSalesNotification){
            $message = 
                "Date: " . date("n/j/Y");
            if ($table_name == 'Lead')
            {
                $message = $message . "\nCompany: " . (property_exists($leadObject, 'Company')? $leadObject->Company : "");
            } else
            {
                $message = $message . "\nCompany: This is a contact, so please look up the Account on SF.";
            }

            $message = $message
                . "\nName: " . (property_exists($leadObject, 'FirstName')? $leadObject->FirstName : "") 
                . " " . (property_exists($leadObject, 'LastName')? $leadObject->LastName : "")
                . "\nEmail: " . $leadObject->Email
                . "\nPhone: " . (property_exists($leadObject, 'Phone')? $leadObject->Phone : "Unknown")
                . "\nActivity: " . $subject;
 
            if ($emailDescription) 
            {
                $message = $message . "\nDescription: \n\n" . $description;        
            } 

            $message = $message . "\n\n"
                . "Record can be accessed via SF at this URL: https://na3.salesforce.com/" . $leadId 
                . "\n\nIP: http://ws.arin.net/cgi-bin/whois.pl?queryinput=" .  $task->ipaddress__c . "\n\n";

            $boo = "AccelerEyes <" . self::SF_SALES_NOTICE_EMAIL . ">";
            $headers = "From: " . $boo . "\r\n";
            $headers .= "Return-Path: " . $boo . "\r\n";
            $headers .= "Reply-To: " . $boo . "\r\n";

            mail($boo, 'SF '. $table_name . ' activity notification', $message,$headers, "-f". self::SF_SALES_NOTICE_EMAIL);
        }
    }

    private function updateIfPropertyExists($oldObj, $newObj, $property, $leadProperty = null)
    {
        if ($leadProperty == null)
        {
            $leadProperty = $property;
        }

        if (($leadProperty == "LastName" || $leadProperty == "Company") && $newObj->$leadProperty == "Unknown")
        {
            return false;
        }

        if (property_exists($newObj, $property)){
            $oldObj->$property = $newObj->$leadProperty;
            return true;
        } else
        {
            return false;
        }
    }

    private function createLeadObjectOnSF($client, $leadObject, $customerId)
    {
        $createResult = $client->create(array($leadObject), "Lead");
        
        if (!$createResult || $createResult->success != true){
            self::sendSalesForceFailureNotice("Failed to insert a new lead record for\n\n." . var_export($leadObject, true)
                                              ."\n\n\n" . var_export($createResult, true));
        }

        $customLink = Mage::getSingleton('core/resource')->getConnection('core_read');	
        $ipaddress = (!empty($_SERVER['REMOTE_ADDR']))? $_SERVER['REMOTE_ADDR'] : 'Unknown';
        $customLink->query("INSERT INTO log_activities (customer_id, activity_desc, ip_Address) "
                           . "VALUES ('". $customerId . "','New SF Lead record','" . $ipaddress . "')");

        $leadId = $createResult->id;

        return $leadId;
    }


    /**
     * Generates a Lead in SalesForce given a client and a SalesForce ready data array.  An
     * attempt is made to first lookup the lead by email and an update is done in that case.
     * Otherwise a new Lead is created.
     *
     * @return The SalesForce ID of the lead, or null to indicate processing should stop in the
     *         calling code.  This may indicate error in some cases.
     */
    private function createOrUpdateLead($client, $leadObject, $leadSource, $customerId){
        ini_set('soap.wsdl_cache_enabled', 0);
        $theEmail = $leadObject->Email;
        error_log(date("Y-m-d H:i:s") . ": Entered Observer.php:createOrUpdateLead\n",3,'/var/www/magento_sandbox/error_log');

        $isContact = false;
        $leadId = null;
        $isNew = true;

        if ($theEmail == '') return null;

        if ($client == null || !is_object($client))
        {
            error_log("Salesforce client is null, Password most likely changed!!!");
            return null;
        }
      
        $current_ip = trim($_SERVER['REMOTE_ADDR']);

        //ok first dtermine if the email already exists in the Contact db
        $contactResult = $client->query("SELECT Id, LeadSource, User_IPs__c FROM Contact WHERE Email = '" . $theEmail . "'");
        //or in the Lead db (notice that we ask the Lead about Converted as well)
        $leadResult = $client->query("SELECT Id, LeadSource, User_IPs__c FROM Lead WHERE Email = '" . $theEmail . "' AND IsConverted <> true");

        if (self::resultCount($contactResult) == 1 || self::resultCount($leadResult) == 1)
        {
            //ok either contact or lead exists hurry!
            //prefer updating contact over lead
            $isNew = false;
            $existingLead = null;
            if (self::resultCount($contactResult) == 1)
            {
                $isContact = true;
                $existingLead = $contactResult->records[0];
            }
            else
            {
                $existingLead = $leadResult->records[0];
            }
          
            $leadId = $existingLead->Id;

            //if the existing leadsource was done via contact us, then we want to fully update all the fields
            if ($existingLead->LeadSource == self::LEAD_CONTACT_US)
            {
                //just copy it over!
                $existingLead = clone $leadObject;
                //but keep the id!
                $existingLead->Id = $leadId;
            }

            if (!$isContact)
            {
                $this->updateIfPropertyExists($existingLead, $leadObject, "Company");
                if ($leadObject->Company == null || $leadObject->Company == '')
                {
                    $existingLead->Company = 'Unknown';
                }
                $this->updateIfPropertyExists($existingLead, $leadObject, "Industry");
                $this->updateIfPropertyExists($existingLead, $leadObject, "Street");
                $this->updateIfPropertyExists($existingLead, $leadObject, "City");
                $this->updateIfPropertyExists($existingLead, $leadObject, "Country");
                $this->updateIfPropertyExists($existingLead, $leadObject, "State");
            }

            $this->updateIfPropertyExists($existingLead, $leadObject, "FirstName");
            $this->updateIfPropertyExists($existingLead, $leadObject, "LastName");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Title");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Phone");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Description");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Lenovo_Model__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Lenovo_Promo_Code__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Lenovo_Serial_Number__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "CUDA_Product__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Reseller_Code__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Primary_Programming_Language__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Primary_Engineering_Application__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Product_Interest__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "HasOptedOutOfEmail");
            $this->updateIfPropertyExists($existingLead, $leadObject, "ArrayFire_Download_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Jacket_Trial_Start__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "WP_ArrayFire_Info_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "WP_GPU_Intro_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "WP_HPC_Server_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "WP_Jacket_Info_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "ArrayFire_Pro_Trial_Start__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Consulting_Inquiry_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "ArrayFire_Deploy_Inquiry_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "ArrayFire_Deploy_Inquiry_Date__c");
            $this->updateIfPropertyExists($existingLead, $leadObject, "Forum_User_Name__c");

            if ($leadObject->FirstName == null)
            {
                $existingLead->FirstName = '';
            }

            if ($leadObject->LastName == null || $leadObject->LastName == '')
            {
                $existingLead->LastName = 'Unknown';
            }

            if ($isContact)
            {
                //ok now remove any fields that shouldn't be there
                unset($existingLead->Company);
                unset($existingLead->City);
                unset($existingLead->Country);
                unset($existingLead->State);
                unset($existingLead->Industry);
                unset($existingLead->Street);
            }

            if (!empty($current_ip) && (!property_exists($existingLead, 'User_IPs__c') || preg_match("/^\s*". $current_ip ."\s*$/m",$existingLead->User_IPs__c,$matches) == 0))
            {
                //ok this ip is not in the list, go ahead and add it
                $existingLead->User_IPs__c .= "\n" . $current_ip;
            }

            //keep track of the last time the user logged in
            $existingLead->Last_Logged_In__c = date("c");

            if ($isContact)
                $client->update(array($existingLead), "Contact");
            else
                $client->update(array($existingLead), "Lead");

        }
        else if (self::resultCount($leadResult) == 0)
        {
            //we need to create a completely new Lead
            error_log(date("Y-m-d H:i:s") . ": Observer.php:createOrUpdateLead:Creating New Lead\n",3,'/var/www/magento_sandbox/error_log');

            if (!empty($current_ip))
            {
                $leadObject->User_IPs__c .= "\n" . $current_ip;
            }

            //set all (new) lead owners to the accelreyes quque
            $leadObject->OwnerId = self::DEFAULT_LEAD_OWNER_ID;

            //else if this is a new email, then go ahead and create a lead
            $leadObject->LeadSource = $leadSource;

            if ($leadObject->Company == null || $leadObject->Company == '')
            {
                $leadObject->Company = 'Unknown';
            }

            if ($leadObject->FirstName == null)
            {
                $leadObject->FirstName = '';
            }

            if ($leadObject->LastName == null || $leadObject->LastName == '')
            {
                $leadObject->LastName = 'Unknown';
            }

            $leadId = $this->createLeadObjectOnSF($client, $leadObject, $customerId);
        }
        else
        {
            self::sendSalesForceFailureNotice("Received more than one Lead match for email " . $theEmail . ". Nothing done.");
        }
   
        return array($leadId, $isContact ? "Contact" : "Lead",$isNew);
    }

    /**
     * By convention we over write a Lead Source value that represents a List
     * Import into SalesForce.  The sources will be prefixed with 'List'.
     * @return Whether or not the lead source should be updated
     */
    private static function replaceLeadSource($leadSource){
        if ($leadSource == null || strlen($leadSource) < 4){
            return false;
        }

        return (strtolower(substr($leadSource, 0, 4)) == "list");
    }

    /**
     * Creates an empty lead with just email set for the cases where we do
     * not know any other information.
     */
    private static function createEmailOnlyLeadData($email){
        $customerData = new StdClass;

        $customerData->FirstName = "";
        $customerData->LastName = "Unknown";  // required field on the salesforce end
        $customerData->Company = "Unknown";   // required field on the salesforce end
        $customerData->Email = $email;

        return $customerData;
    }

    private static function getCustomerId($magentoEvent){
        $customer = $magentoEvent->getCustomer();
        if ($customer != null){
            $id = $customer->getId();
            if ($id != null){
                return $id;
            }
        }

        return null;
    }	  


    private static function createPropertyIfNeeded($property,$key,$ci,$out)
    {
        if (isset($ci[$key]))
            $out->$property = $ci[$key];
    }
  
    /**
     * Extracts customer information from fired 'customer_save_after' Magento events and
     * converts to a SalesForce-compatible array of data.
     */
    private static function createLeadData($magentoEvent,$pureCustomer=null){
        
        $customer = null;
        if ($pureCustomer != null)
        {
            $customer = $pureCustomer;
        } else
        {
            $customer = $magentoEvent->getCustomer();
        }

        $customerInfo = array();

        // merge in the stuff on the address if available
        $addresses = $customer->getAddresses();
        if (current($addresses) != false){
            $address = current($addresses);
            $dataFromAddress = $address->getData();
            foreach($dataFromAddress as $key => $value){
                if (!array_key_exists($key, $customerInfo)){
                    $customerInfo[$key] = $value;
                }
            }
        }

        // merge in the stuff on the customer (why doesn't magento make these the same?)
        //TODO: editing customer info from front-end like First name doesn't work until you update the address book which really sucks!!  
        // It should be updated on contact information section instead!!
        // things like firstname, lastname, company, 
        $dataFromCustomer = $customer->getData();
        foreach($dataFromCustomer as $key => $value){
            if (!array_key_exists($key, $customerInfo)){
                $customerInfo[$key] = $value;
            }
        }

        $customerData = new StdClass;

        self::createPropertyIfNeeded('FirstName','firstname',$customerInfo,$customerData);
        self::createPropertyIfNeeded('LastName','lastname',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Email','email',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Title','occupation',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Company','company',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Phone','telephone',$customerInfo,$customerData);
        self::createPropertyIfNeeded('City','city',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Country','country_id',$customerInfo,$customerData);
        self::createPropertyIfNeeded('State','region',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Industry','industry',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Street','street',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Description','reason',$customerInfo,$customerData);
        self::createPropertyIfNeeded('CUDA_Product__c','cuda_product',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Reseller_Code__c','resellercode',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Primary_Programming_Language__c','primary_programming_lang',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Primary_Engineering_Application__c','primary_engineering_application',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Product_Interest__c','product_interest',$customerInfo,$customerData);
        self::createPropertyIfNeeded('HasOptedOutOfEmail','is_subscribed',$customerInfo,$customerData);
        self::createPropertyIfNeeded('Forum_User_Name__c','forum_username',$customerInfo,$customerData);

        if (!empty($customerData->State) && strlen($customerData->State) > 2){
            $customerData->State = self::convertStateForSF($customerData->State);
        }

        if (!empty($customerData->Country) && strlen($customerData->Country) > 0){
            $customerData->Country = self::getCountryName($customerData->Country);
        }

        // convert US to USA to match other SalesForce records
        if (!empty($customerData->Country) && $customerData->Country == "US"){
            $customerData->Country = "USA";
        }

        return $customerData;
    }

    /**
     * Null safe helper for getting number of results from SalesForce.  Handles the couple different
     * variants SalesForce has for result counts.
     */
    private static function resultCount($salesForceResult){
        if (!$salesForceResult) return 0;
        if (property_exists($salesForceResult, 'size')) return $salesForceResult->size;
        return count($salesForceResult);
    }

    private static function sendSalesForceFailureNotice($errorMessage){
        $body = "Received an exception while talking to SalesForce.\n\n" . $errorMessage;

        $boo = "AccelerEyes <" . self::SF_SALES_NOTICE_EMAIL . ">";
        $headers = "From: " . $boo . "\r\n";
        $headers .= "Return-Path: " . $boo . "\r\n";
        $headers .= "Reply-To: " . $boo . "\r\n";

        mail($boo, "Error in Magento --> SalesForce integration", $body, $headers, "-f". self::SF_SALES_NOTICE_EMAIL);

        return null;
    }

    /**
     * Cannot figure out how to get this mapping from Magento, so have a huge hard-coded map
     * lookup here.
     */
    private static function getCountryName($abbr){
        $countries = array(
            "AF"=>"Afghanistan",
            "AX"=>"Aland Islands",
            "AL"=>"Albania",
            "DZ"=>"Algeria",
            "AS"=>"American Samoa",
            "AD"=>"Andorra",
            "AO"=>"Angola",
            "AI"=>"Anguilla",
            "AQ"=>"Antarctica",
            "AG"=>"Antigua and Barbuda",
            "AR"=>"Argentina",
            "AM"=>"Armenia",
            "AW"=>"Aruba",
            "AU"=>"Australia",
            "AT"=>"Austria",
            "AZ"=>"Azerbaijan",
            "BS"=>"Bahamas",
            "BH"=>"Bahrain",
            "BD"=>"Bangladesh",
            "BB"=>"Barbados",
            "BY"=>"Belarus",
            "BE"=>"Belgium",
            "BZ"=>"Belize",
            "BJ"=>"Benin",
            "BM"=>"Bermuda",
            "BT"=>"Bhutan",
            "BO"=>"Bolivia",
            "BA"=>"Bosnia and Herzegovina",
            "BW"=>"Botswana",
            "BV"=>"Bouvet Island",
            "BR"=>"Brazil",
            "IO"=>"British Indian Ocean Territory",
            "VG"=>"British Virgin Islands",
            "BN"=>"Brunei",
            "BG"=>"Bulgaria",
            "BF"=>"Burkina Faso",
            "BI"=>"Burundi",
            "KH"=>"Cambodia",
            "CM"=>"Cameroon",
            "CA"=>"Canada",
            "CV"=>"Cape Verde",
            "KY"=>"Cayman Islands",
            "CF"=>"Central African Republic",
            "TD"=>"Chad",
            "CL"=>"Chile",
            "CN"=>"China",
            "CX"=>"Christmas Island",
            "CC"=>"Cocos Islands",
            "CO"=>"Colombia",
            "KM"=>"Comoros",
            "CG"=>"Congo - Brazzaville",
            "CD"=>"Congo - Kinshasa",
            "CK"=>"Cook Islands",
            "CR"=>"Costa Rica",
            "HR"=>"Croatia",
            "CY"=>"Cyprus",
            "CZ"=>"Czech Republic",
            "DK"=>"Denmark",
            "DJ"=>"Djibouti",
            "DM"=>"Dominica",
            "DO"=>"Dominican Republic",
            "EC"=>"Ecuador",
            "EG"=>"Egypt",
            "SV"=>"El Salvador",
            "GQ"=>"Equatorial Guinea",
            "ER"=>"Eritrea",
            "EE"=>"Estonia",
            "ET"=>"Ethiopia",
            "FK"=>"Falkland Islands",
            "FO"=>"Faroe Islands",
            "FJ"=>"Fiji",
            "FI"=>"Finland",
            "FR"=>"France",
            "GF"=>"French Guiana",
            "PF"=>"French Polynesia",
            "TF"=>"French Southern Territories",
            "GA"=>"Gabon",
            "GM"=>"Gambia",
            "GE"=>"Georgia",
            "DE"=>"Germany",
            "GH"=>"Ghana",
            "GI"=>"Gibraltar",
            "GR"=>"Greece",
            "GL"=>"Greenland",
            "GD"=>"Grenada",
            "GP"=>"Guadeloupe",
            "GU"=>"Guam",
            "GT"=>"Guatemala",
            "GN"=>"Guinea",
            "GW"=>"Guinea-Bissau",
            "GY"=>"Guyana",
            "HT"=>"Haiti",
            "HM"=>"Heard Island and McDonald Islands",
            "HN"=>"Honduras",
            "HK"=>"Hong Kong",
            "HU"=>"Hungary",
            "IS"=>"Iceland",
            "IN"=>"India",
            "ID"=>"Indonesia",
            "IQ"=>"Iraq",
            "IE"=>"Ireland",
            "IL"=>"Israel",
            "IT"=>"Italy",
            "CI"=>"Ivory Coast",
            "JM"=>"Jamaica",
            "JP"=>"Japan",
            "JO"=>"Jordan",
            "KZ"=>"Kazakhstan",
            "KE"=>"Kenya",
            "KI"=>"Kiribati",
            "KW"=>"Kuwait",
            "KG"=>"Kyrgyzstan",
            "LA"=>"Laos",
            "LV"=>"Latvia",
            "LB"=>"Lebanon",
            "LS"=>"Lesotho",
            "LR"=>"Liberia",
            "LI"=>"Liechtenstein",
            "LT"=>"Lithuania",
            "LU"=>"Luxembourg",
            "MO"=>"Macau",
            "MK"=>"Macedonia",
            "MG"=>"Madagascar",
            "MW"=>"Malawi",
            "MY"=>"Malaysia",
            "MV"=>"Maldives",
            "ML"=>"Mali",
            "MT"=>"Malta",
            "MH"=>"Marshall Islands",
            "MQ"=>"Martinique",
            "MR"=>"Mauritania",
            "MU"=>"Mauritius",
            "YT"=>"Mayotte",
            "FX"=>"Metropolitan France",
            "MX"=>"Mexico",
            "FM"=>"Micronesia",
            "MD"=>"Moldova",
            "MC"=>"Monaco",
            "MN"=>"Mongolia",
            "MS"=>"Montserrat",
            "MA"=>"Morocco",
            "MZ"=>"Mozambique",
            "NA"=>"Namibia",
            "NR"=>"Nauru",
            "NP"=>"Nepal",
            "NL"=>"Netherlands",
            "AN"=>"Netherlands Antilles",
            "NC"=>"New Caledonia",
            "NZ"=>"New Zealand",
            "NI"=>"Nicaragua",
            "NE"=>"Niger",
            "NG"=>"Nigeria",
            "NU"=>"Niue",
            "NF"=>"Norfolk Island",
            "MP"=>"Northern Mariana Islands",
            "NO"=>"Norway",
            "OM"=>"Oman",
            "PK"=>"Pakistan",
            "PW"=>"Palau",
            "PS"=>"Palestinian Territory",
            "PA"=>"Panama",
            "PG"=>"Papua New Guinea",
            "PY"=>"Paraguay",
            "PE"=>"Peru",
            "PH"=>"Philippines",
            "PN"=>"Pitcairn",
            "PL"=>"Poland",
            "PT"=>"Portugal",
            "PR"=>"Puerto Rico",
            "QA"=>"Qatar",
            "RE"=>"Reunion",
            "RO"=>"Romania",
            "RU"=>"Russia",
            "RW"=>"Rwanda",
            "SH"=>"Saint Helena",
            "KN"=>"Saint Kitts and Nevis",
            "LC"=>"Saint Lucia",
            "PM"=>"Saint Pierre and Miquelon",
            "VC"=>"Saint Vincent and the Grenadines",
            "WS"=>"Samoa",
            "SM"=>"San Marino",
            "ST"=>"Sao Tome and Principe",
            "SA"=>"Saudi Arabia",
            "SN"=>"Senegal",
            "CS"=>"Serbia and Montenegro",
            "SC"=>"Seychelles",
            "SL"=>"Sierra Leone",
            "SG"=>"Singapore",
            "SK"=>"Slovakia",
            "SI"=>"Slovenia",
            "SB"=>"Solomon Islands",
            "SO"=>"Somalia",
            "ZA"=>"South Africa",
            "GS"=>"South Georgia and the South Sandwich Islands",
            "KR"=>"South Korea",
            "ES"=>"Spain",
            "LK"=>"Sri Lanka",
            "SR"=>"Suriname",
            "SJ"=>"Svalbard and Jan Mayen",
            "SZ"=>"Swaziland",
            "SE"=>"Sweden",
            "CH"=>"Switzerland",
            "TW"=>"Taiwan",
            "TJ"=>"Tajikistan",
            "TZ"=>"Tanzania",
            "TH"=>"Thailand",
            "TG"=>"Togo",
            "TK"=>"Tokelau",
            "TO"=>"Tonga",
            "TT"=>"Trinidad and Tobago",
            "TN"=>"Tunisia",
            "TR"=>"Turkey",
            "TM"=>"Turkmenistan",
            "TC"=>"Turks and Caicos Islands",
            "TV"=>"Tuvalu",
            "VI"=>"U.S. Virgin Islands",
            "UG"=>"Uganda",
            "UA"=>"Ukraine",
            "AE"=>"United Arab Emirates",
            "GB"=>"United Kingdom",
            "US"=>"United States",
            "UM"=>"United States Minor Outlying Islands",
            "UY"=>"Uruguay",
            "UZ"=>"Uzbekistan",
            "VU"=>"Vanuatu",
            "VA"=>"Vatican",
            "VE"=>"Venezuela",
            "VN"=>"Vietnam",
            "WF"=>"Wallis and Futuna",
            "EH"=>"Western Sahara",
            "YE"=>"Yemen",
            "ZM"=>"Zambia",
            "ZW"=>"Zimbabwe"
            );

        // sales team requested custom logic comes first
        if (strtoupper($abbr) == "US" || strtoupper($abbr) == "United States"){
            return "USA";
        } 
        else if (strtoupper($abbr) == "UK" || strtoupper($abbr) == "GB" || strtoupper($abbr) == "Great Britain"){
            return "UK";
        }
        else if (isset($countries[strtoupper($abbr)])){
            return $countries[strtoupper($abbr)];
        }
        else{
            return $abbr;
        }
    }

    /**
     * Cannot figure out a clean way to get this from Magento so manually converting to the state
     * abbreviations that our SalesForce users prefer on that end.  State list from USPS.
     * @return Corresponding abbreviation or original input if none found
     */
    private static function convertStateForSF($stateName){
        $states = array (
            "ALABAMA"=>"AL",
            "ALASKA"=>"AK",
            "AMERICAN SAMOA"=>"AS",
            "ARIZONA"=>"AZ",
            "ARKANSAS"=>"AR",
            "ARMED FORCES AFRICA"=>"AE",
            "ARMED FORCES AMERICAS"=>"AA",
            "ARMED FORCES CANADA"=>"AE",
            "ARMED FORCES EUROPE"=>"AE",
            "ARMED FORCES MIDDLE EAST"=>"AE",
            "ARMED FORCES PACIFIC"=>"AP",
            "CALIFORNIA"=>"CA",
            "COLORADO"=>"CO",
            "CONNECTICUT"=>"CT",
            "DELAWARE"=>"DE",
            "DISTRICT OF COLUMBIA"=>"DC",
            "FEDERATED STATES OF MICRONESIA"=>"FM",
            "FLORIDA"=>"FL",
            "GEORGIA"=>"GA",
            "GUAM"=>"GU",
            "HAWAII"=>"HI",
            "IDAHO"=>"ID",
            "ILLINOIS"=>"IL",
            "INDIANA"=>"IN",
            "IOWA"=>"IA",
            "KANSAS"=>"KS",
            "KENTUCKY"=>"KY",
            "LOUISIANA"=>"LA",
            "MAINE"=>"ME",
            "MARSHALL ISLANDS"=>"MH",
            "MARYLAND"=>"MD",
            "MASSACHUSETTS"=>"MA",
            "MICHIGAN"=>"MI",
            "MINNESOTA"=>"MN",
            "MISSISSIPPI"=>"MS",
            "MISSOURI"=>"MO",
            "MONTANA"=>"MT",
            "NEBRASKA"=>"NE",
            "NEVADA"=>"NV",
            "NEW HAMPSHIRE"=>"NH",
            "NEW JERSEY"=>"NJ",
            "NEW MEXICO"=>"NM",
            "NEW YORK"=>"NY",
            "NORTH CAROLINA"=>"NC",
            "NORTH DAKOTA"=>"ND",
            "NORTHERN MARIANA ISLANDS"=>"MP",
            "OHIO"=>"OH",
            "OKLAHOMA"=>"OK",
            "OREGON"=>"OR",
            "PALAU"=>"PW",
            "PENNSYLVANIA"=>"PA",
            "PUERTO RICO"=>"PR",
            "RHODE ISLAND"=>"RI",
            "SOUTH CAROLINA"=>"SC",
            "SOUTH DAKOTA"=>"SD",
            "TENNESSEE"=>"TN",
            "TEXAS"=>"TX",
            "UTAH"=>"UT",
            "VERMONT"=>"VT",
            "VIRGINIA"=>"VA",
            "VIRGIN ISLANDS"=>"VI",
            "WASHINGTON"=>"WA",
            "WEST VIRGINIA"=>"WV",
            "WISCONSIN"=>"WI",
            "WYOMING"=>"WY"
            );    

        if (isset($states[strtoupper($stateName)])){
            return $states[strtoupper($stateName)];
        }
        else{
            return $stateName;
        }
    }
  
}
