<?php /*

Copyright (c) 2008 Metathinking Ltd.

This file is part of Affiliates For All.

Affiliates For All is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

Affiliates For All is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Affiliates For All.  If not, see
<http://www.gnu.org/licenses/>.

*/

class Accelereyes_Reseller_Model_Observer {
    private $affiliate_referrer_parameter, $affiliate_data_parameter,
            $affiliate_cookie, $cookie_lifetime, $new_order;


    public function __construct() {
        $this->affiliate_referrer_parameter = 'ref';
        $this->affiliate_cookie = 'affiliate';
        $this->cookie_lifetime = 90;
        $this->new_order = FALSE;
    }

    public function set_affiliate_cookie($observer) {

        $response = null;

        if(isset($_GET[$this->affiliate_referrer_parameter]))
        {

            $data = intval($_GET[$this->affiliate_referrer_parameter]);

            $response = array($this->affiliate_cookie, $data,
                time() + 60 * 60 * 24 * $this->cookie_lifetime, '/');

        }

        if($response && count($response) > 0)
            call_user_func_array('setcookie', $response);

        return $this;
    }

    public function order_placed($observer) {
        $this->new_order = TRUE;
        return $this;
    }

    public function model_saved($observer) {

        error_log('*** Model Saved Called ***');

        $event = $observer->getEvent();
        $order = $event->getOrder();

        if($this->new_order) {

            error_log('** New Order **');

            $customer_id = (string) $order->getCustomerId();
            $customer = Mage::getModel('customer/customer')
                ->load($customer_id);

            if(isset($_COOKIE[$this->affiliate_cookie]))
                $affiliate = intval($_COOKIE[$this->affiliate_cookie]);

            if($affiliate == null && $customer_id != '')
            {

                $customerCode = Mage::getModel('customer/customer')
                    ->load($customer_id)
                    ->getResellercode();

                $affiliate = Mage::getModel('reseller/reseller')
                    ->loadByCode($customerCode)
                    ->getResellerId();

            }

            if($affiliate != null)
            {

                $reseller = Mage::getModel('reseller/reseller')->load($affiliate);

                $resellerTotal =
                    $order->getData('subtotal') -
                    $order->getData('discount_amount');

                $resellerCommission =
                    $resellerTotal * ($reseller->getCommissionRate()/100);

                $data = array(
                    'resellerorder_id' => '5',
                    'order_id' => $order->getId(),
                    'reseller_id' => $affiliate,
                    'total' => $resellerTotal,
                    'commission' => $resellerCommission,
                    'status' => 'open',
                    'customer_id' => $customer_id);

                $resellerOrder = Mage::getModel('reseller/resellerOrder')->setData($data);
                $resellerOrder->setResellerOrderId('5');
                $resellerOrder->setOrderId($order->getId());
                $resellerOrder->setResellerId($affiliate);
                $resellerOrder->setTotal($resellerTotal);
                $resellerOrder->setCommission($resellerCommission);
                $resellerOrder->setStatus('open');
                $resellerOrder->setCustomerId($customer_id);
                $resellerOrder->setDateDue(
                    date('Y-m-d h:i:s', time()+($reseller->getPaymentTerms()*86400))
                );

                error_log("New RO: " . print_r($resellerOrder, true));

                $resellerOrder->save();

            }

        }

        if($order->getStatus() == "complete" || $order->getStatus() == "closed")
        {

            $resellerOrder = Mage::getModel('reseller/resellerOrder')
                ->load($order->getId());
            $resellerOrder->setStatus('closed');
            $resellerOrder->save();

        }

        if($order->getStatus() == "canceled")
        {

            $resellerOrder = Mage::getModel('reseller/resellerOrder')
                ->load($order->getId());
            $resellerOrder->setStatus('canceled');
            $resellerOrder->save();

        }

        return $this;

    }

}
