<?php

class Accelereyes_Reseller_Block_Admin_Orders_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('resellerOrderGrid');
        $this->_controller = 'reseller_admin';

    }

    protected function _prepareCollection()
    {

        $model = Mage::getModel('reseller/resellerOrder');
        $collection = $model->getCollection();

        foreach($collection as $item)
        {

            $customer = Mage::getModel('customer/customer')->load($item->getData('customer_id'));
            $customerName = $customer->getName();
            $customerEmail = $customer->getEmail();

            $item->addData(array('customer_name'=>$customerName));
            $item->addData(array('customer_email'=>$customerEmail));

        }

        $this->setCollection($collection);

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('order_id', array(
            'header'        => Mage::helper('reseller')->__('Order ID'),
            'align'         => 'left',
            'width'         => '50px',
            'filter_index'  => 'order_id',
            'index'         => 'order_id',
        ));
        $this->addColumn('reseller_id', array(
            'header'        => Mage::helper('reseller')->__('Reseller ID'),
            'align'         => 'left',
            'width'         => '50px',
            'filter_index'  => 'reseller_id',
            'index'         => 'reseller_id',
        ));
        $this->addColumn('customer_id', array(
            'header'        => Mage::helper('reseller')->__('Customer ID'),
            'index'         => 'customer_id'
        ));
        $this->addColumn('customer_email', array(
            'header'        => Mage::helper('reseller')->__('Customer Email'),
            'index'         => 'customer_email'
        ));
        $this->addColumn('customer_name', array(
            'header'        => Mage::helper('reseller')->__('Customer Name'),
            'index'         => 'customer_name'
        ));
        $this->addColumn('total', array(
            'header'        => Mage::helper('reseller')->__('Order Total'),
            'index'         => 'total'
        ));
        $this->addColumn('commission', array(
            'header'        => Mage::helper('reseller')->__('Commission Earned'),
            'index'         => 'commission'
        ));
        $this->addColumn('status', array(
            'header'        => Mage::helper('reseller')->__('Status'),
            'type'          => 'text',
            'index'         => 'status'
        ));
        $this->addColumn('date_entered', array(
            'header'        => Mage::helper('reseller')->__('Date Entered'),
            'type'          => 'date',
            'index'         => 'date_entered'
        ));
        $this->addColumn('date_due', array(
            'header'        => Mage::helper('reseller')->__('Date Due'),
            'type'          => 'date',
            'index'         => 'date_due'
        ));
        $this->addColumn('action',
            array(
                'header'    => Mage::helper('reseller')->__('Action'),
                'width'     => '100px',
                'type'      => 'action',
                'getter'    => 'getId',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('reseller')->__('Edit Record'),
                        'url'       => array(
                            'base'  => '*/*/editOrder'
                        ),
                        'field'     => 'id',
                    ),
                    array(
                        'caption'   => Mage::helper('reseller')->__('View Order'),
                        'url'       => array(
                            'base'  => 'adminhtml/sales_order/view'
                        ),
                        'field'     => 'order_id',
                    ),
                    array(
                        'caption'   => Mage::helper('reseller')->__('Delete Record'),
                        'url'       => array(
                            'base'  => '*/*/deleteOrder'
                        ),
                        'field'     => 'id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false
        ));

        return parent::_prepareColumns();

    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/orders', array('_current'=>true));
    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/editOrder', array(
            'id' => $row->getId(),
        ));

    }

}
