<?php

class Accelereyes_Reseller_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

  public function __construct()
  {
    parent::__construct();
    $this->setId('resellerGrid');
    $this->_controller = 'reseller';
  }

  protected function _prepareCollection()
  {
    $model = Mage::getModel('reseller/reseller');
    $collection = $model->getCollection();
    $this->setCollection($collection);

    return parent::_prepareCollection();
  }

  protected function _prepareColumns()
  {
    $this->addColumn('reseller_id', array(
						'header'        => Mage::helper('reseller')->__('ID'),
						'align'         => 'align',
						'width'         => '50px',
						'filter_index'  => 'reseller_id',
						'index'         => 'reseller_id',
						));

    $this->addColumn('company', array(
					   'header' => Mage::helper('reseller')->__('Company'),
					   'align' => 'left',
					   'width' => '150px',
					   'filter_index' => 'company',
					   'index' => 'company',
					   'type' => 'text',
					   'truncate' => 50,
					   'escape' => true,
					   ));

    $this->addColumn('reseller_code', array(
					   'header' => Mage::helper('reseller')->__('Reseller Code'),
					   'align' => 'left',
					   'width' => '100px',
					   'filter_index' => 'reseller_code',
					   'index' => 'reseller_code',
					   'type' => 'text',
					   'escape' => true,
					   ));

    $this->addColumn('commission_rate', array(
					   'header' => Mage::helper('reseller')->__('Commission Rate'),
					   'align' => 'left',
					   'width' => '25px',
					   'filter_index' => 'commission_rate',
					   'index' => 'commission_rate',
					   'type' => 'text',
					   ));

    $this->addColumn('payment_terms', array(
					   'header' => Mage::helper('reseller')->__('Payment Terms
					   (days)'),
					   'align' => 'left',
					   'width' => '25px',
					   'filter_index' => 'payment_terms',
					   'index' => 'payment_terms',
					   'type' => 'text',
					   ));

    $this->addColumn('address', array(
					   'header' => Mage::helper('reseller')->__('Address'),
					   'align' => 'left',
					   'width' => '150px',
					   'filter_index' => 'address',
					   'index' => 'address',
					   'type' => 'text',
					   'truncate' => 50,
					   'escape' => true,
					   ));

    $this->addColumn('action',
        array(
            'header'    => Mage::helper('reseller')->__('Action'),
            'width'     => '150px',
            'type'      => 'action',
            'getter'    => 'getResellerId',
            'actions'   => array(
                array(
                    'caption'   => Mage::helper('reseller')->__('Edit'),
                    'url'       => array(
                        'base'  => '*/*/edit'
                    ),
                    'field'     => 'id',
                ),
                array(
                    'caption'   => Mage::helper('reseller')->__('Delete'),
                    'url'       => array(
                        'base'  => '*/*/delete'
                    ),
                    'field'     => 'id'
                )
            ),
            'filter'    => false,
            'sortable'  => false
        ));

    return parent::_prepareColumns();

  }

  public function getRowUrl($row)
  {
    return $this->getUrl('*/*/edit', array('id' => $row->getResellerId()));
  }
}
