<?php

class Accelereyes_Qla_Model_Qla extends Mage_Core_Model_Abstract
{

  protected function _construct()
  {
    $this->_init('qla/qla');
  }

  public function generateLicenseKey()
  {
    if ($this->getLicenseKey() != null && strlen(trim($this->getLicenseKey())) > 0){
      // this is only a sanity check in case user bypasses client-side validation
      return;
    }

    $inputString = $this->getVersion() . 
      '_' . $this->getType() .
      '_' . $this->getMatlabLicense();

    $hashedString = sha1($inputString);
    $this->setLicenseKey(substr($hashedString, 0, 20) . 
			 '-' .
			 substr($hashedString, 20)
			 );
    $this->save();
  }

  public function getCustomerLicenses($customerId)
  {
      $collection = $this->getResourceCollection()
	  ->addFieldToFilter('customer_id', $customerId);
      return $collection;
  }
}

/**
str = version_code + "_" + license_type + "_" + matlab_license // e.g.,
"qla.v1_single_123456"
hash = sha1(str)
key = hash[1:20] + "-" + hash[21:40] // split the hash in two and
connect with a "-", e.g. "13661253bd80c1180d3f-d0c794e3c3fb19bfa782"

*/
?>