<?php

class Accelereyes_LicenseLibjacket_Model_Order extends Mage_Core_Model_Abstract
{

  protected function _construct()
  {
    $this->_init('licenselibjacket/order');
  }

  public function customerHasLicenseOrderForOrder($customerId, $orderNum)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId)
      ->addFieldToFilter('order_number', $orderNum);
    return count($collection) > 0;

  }

  public function getCustomerLicenseOrders($customerId)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId);
    return $collection;
  }

  public function getUnallocatedLicenseOrderCount($customerId)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId)
      ->addFieldToFilter('allocated', 0);
    return count($collection);
  }

  public function setCustomerLicenseOrdersAllocated($customerId)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId)
      ->addFieldToFilter('allocated', 0);

    foreach($collection as $order)
    {
      $order->setAllocated(1);
      $order->save();
    }
  }

  public function getCustomerUnallocatedTotals($customerId)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId)
      ->addFieldToFilter('allocated', 0);

    $totals = $this->getEmptyTotalsArray();
    foreach($collection as $order)
    {
      if( ! $order->getAllocated() == 0) { continue; }

      $totals['base'] += $order->getBase();
      $totals['jla'] += $order->getJla();
      $totals['sla'] += $order->getSla();
      $totals['mgl'] += $order->getMgl();
      $totals['hpc'] += $order->getHpc();
      $totals['sms'] += $order->getSms();
      $totals['phone'] += $order->getPhone();
      $totals['cn'] += $order->getCn();
      $totals['qty_mgl2'] += $order->getQtyMgl2();
      $totals['qty_mgl4'] += $order->getQtyMgl4();
      $totals['qty_mgl8'] += $order->getQtyMgl8();
      $totals['qty_mgl2_phone'] += $order->getQtyMgl2Phone();
      $totals['qty_mgl4_phone'] += $order->getQtyMgl4Phone();
      $totals['qty_mgl8_phone'] += $order->getQtyMgl8Phone();

    }

    return $totals;
  }

  public function getCustomerUnallocatedOrderNumber($customerId)
  {
    $collection = $this->getResourceCollection()
      ->addFieldToFilter('customer_id', $customerId)
      ->addFieldToFilter('allocated', 0);

    foreach($collection as $order) {
      if($order->getBase() > 0 && $order->getOrderNumber() != 0) {
	return $order->getOrderNumber();
      }
    }
    return 0;
  }

  public function getProductArray()
  {
    return array('jla', 'sla', 'mgl', 'hpc');
  }

  public function getEmptyTotalsArray()
  {
    $totals = array(
      'base' => 0,
      'jla' => 0,
      'sla' => 0,
      'mgl' => 0,
      'hpc' => 0,
      'sms' => 0,
      'phone' => 0,
      'cn' => 0,
      'qty_mgl2'=> 0,
      'qty_mgl4'=> 0,
      'qty_mgl8'=> 0,
      'qty_mgl2_phone'=> 0,
      'qty_mgl4_phone'=> 0,
      'qty_mgl8_phone'=> 0,
    );
    return $totals;
  }

  public function generateSingleLicense($customerId, $orderNumber = 0)
  {
    $groupModel = Mage::getModel('customer/group');
    $customerGroupId = Mage::getModel('customer/session')->getCustomerGroupId();
    $customerGroupName = $groupModel
      ->load($customerGroupId)
      ->getCustomerGroupCode();

    $customerType = 'commercial';
    if($customerGroupName=='Student'){
      $customerType = 'student';
    } elseif($customerGroupName=='Academic') {
      $customerType = 'academic';
    } elseif($customerGroupName=='Government / Research') {
      $customerType = 'government';
    }

    $version = Mage::getModel('versionlibjacket/version')->getCurrentVersionNumber();

    $totals =  $this->getCustomerUnallocatedTotals($customerId);

    if($totals['base'] != 1) { return false; }

    $itemSku = 666;

    $month = date('m');
    $day = date('d');
    $year = date('Y');
    $hour = date('H');
    $minute = date('i');

    $license = Mage::getModel('licenselibjacket/license');
      
    $license->setMaintenanceDate(mktime($hour, $minute, 0, $month, $day, $year+1+$totals['sms']));
    $supportDate = ($totals['phone'] > 0) ? mktime(0,0,0,$month, $day, $year+1) : 0; 
    $license->setSupportDate($supportDate);

    $license->setMgo(max($totals['mgl'], 1));
    $license->setMgl(max($totals['mgl'], 1));
    $license->setCn(0);
    $license->setJla($totals['jla']);
    $license->setSla($totals['sla']);
    $license->setGfxToolbox(1);
    $license->setCustomerId($customerId);
    $license->setUserType($customerType);
    $license->setPurchaseDate(mktime($hour, $minute, 0, $month, $day, $year));
    $license->setProductSku('666');
    $license->setPaid(1);
    $license->setVersion($version);
    if($orderNumber != 0) { $license->setOrderNumber($orderNumber); }
    $license->setLicenseCode($license->generateLicenseCode());
    $license->save();

    Mage::getModel('licenselibjacket/order')->setCustomerLicenseOrdersAllocated($customerId);

    return true;

  }

  public function isEmpty()
  {
    $total = 0;
    $total += $this->getBase();
    $total += $this->getJla();
    $total += $this->getSla();
    $total += $this->getMgl();
    $total += $this->getHpc();
    $total += $this->getSms();
    $total += $this->getPhone();
    $total += $this->getCn();
    $total += $this->getQtyMgl2();
    $total += $this->getQtyMgl4();
    $total += $this->getQtyMgl8();
    $total += $this->getQtyMgl2Phone();
    $total += $this->getQtyMgl4Phone();
    $total += $this->getQtyMgl8Phone();

    return ($total == 0);
  }
}