<?php

class Accelereyes_LicenseLibjacket_Model_Observer extends Mage_Core_Model_Abstract
{

  /**
   * See if there are any externally purchased licenses in the session
   * that need to be added to this account.
   */
  public function customerCreated($observer){
    try{
      $licenseExternalUuid = false;
      $licenseNumber = false;

      foreach ($_COOKIE as $key => $value){
        if (strstr($key, "JACKET_EXTERNAL_NUM")){
          $licenseNumber = $_COOKIE[$key];
          setcookie($key, "", time() - 3600);
        }
        else if (strstr($key, "JACKET_EXTERNAL_UUID")){
          $licenseExternalUuid = $_COOKIE[$key];
          setcookie($key, "", time() - 3600);
        }
      }

      if ($licenseExternalUuid !== false && $licenseNumber !== false){
        $link = Mage::getSingleton('core/resource')->getConnection('core_read');
        $licenseExternalUuid = trim(mysql_escape_string($licenseExternalUuid));
        $licenseNumber = trim(mysql_escape_string($licenseNumber));

        $result = $link->fetchAll("SELECT * FROM license WHERE license_number = '" . $licenseNumber .
             "' AND external_license_uuid = '" . $licenseExternalUuid . "' and external_claimed = 0");

        if ($result && count($result) == 1){
          $maintenanceDate = time() + (365 * 24 * 60 * 60);
          $customerId = $observer->getEvent()->getCustomer()->getId();

          $link->query("UPDATE license SET customer_id = '" . $customerId .
             "', external_claimed = 1, maintenance_date = " . $maintenanceDate .
             " WHERE license_number = '" . $licenseNumber . "' LIMIT 1");
        }
      }
    }
    catch(Exception $e){
      error_log("Unexpected error encountered while checking for external license purchases:");
      error_log(print_r($e->getMessage(), true));
    }
  }


    /**
     * Record the license information for each product.
     *
     * @triggeredby: sales_order_place_after
     * @param $observer array "order"=>$order
     */
    public function recordLicenseOrderForOrderEvent($observer)
    {
      try {
        date_default_timezone_set('EST');

        $order = $observer->getEvent()->getOrder();

        // custom logic to set correct initial states for orders since the
        // settings in admin interface get completely ignored by Magento
        // this is certainly a hack and at the very least should be isolated
        // in its own module

        if ($order['status'] == "pending" && $order['state'] == "new"){
          $order['status'] = "quotewerks";
          $order->save();
        }
	if (($order['status'] == "processing" || $order['status'] == "complete") && $order['state'] == "new"){
	  $order['status'] = "pending";
          $order->save();
	}

        $items = $order->getItemsCollection();

        $customerId = Mage::getModel('customer/session')->getCustomerId();
        $groupModel = Mage::getModel('customer/group');
        $customerGroupId = Mage::getModel('customer/session')->getCustomerGroupId();
        $customerGroupName = $groupModel
          ->load($customerGroupId)
          ->getCustomerGroupCode();

		$customerType = 'commercial';

		if($customerGroupName=='Student'){
			$customerType = 'student';
		} elseif($customerGroupName=='Academic') {
			$customerType = 'academic';
		} elseif($customerGroupName=='Government / Research') {
			$customerType = 'government';
		}

        $licenseOrder = Mage::getModel('licenselibjacket/order');

	// Prevent duplicate license orders from being created.
	if ($licenseOrder->customerHasLicenseOrderForOrder($customerId, $order->getIncrementId()) === true) {
	   return;
	}

        $licenseOrder->setCustomerId($customerId);

        try {

          $licenseOrder->setOrderNumber($order->getIncrementId());

        } catch (Exception $e) {

          error_log('License Order Observer error:\n' . $e->getMessage());

        }

	$containsNewLicenses = false;
        
        $addonMessageAdded = array();
        
        $existingLicenseNumberList = array();  // distinct licenses in addon items will get added to this
        
        foreach ($items as $_item) {
	    $qlaSkus = array('QLA-SINGLE', 'QLA-MULTI', 'QLA-SITE');
            if($_item->getParentItem()) { continue;  }
	    $quantity = $_item->getQtyOrdered();
            $itemSku = $_item->getSku();
	    if(in_array($itemSku, $qlaSkus)) { continue; }
            
            $existingLicenseNumber = null;
            
            // lame, fragile hack, but found no other way
            if (strstr($_item->getDescription(), "addon for license")){
              $existingLicenseNumber = preg_replace('/[^0-9]/', '', $_item->getDescription());
            }
            
            if ($existingLicenseNumber != null){
	      // SHOULDN'T GET HERE YET
              // we are adding features or support to an existing license
              
              if (!in_array($existingLicenseNumber, $existingLicenseNumberList)){
                $existingLicenseNumberList[] = $existingLicenseNumber;
              }
              
              $existingLicense = Mage::getModel('licenselibjacket/license')
                  ->getLicenseByNumberAndCustomer($existingLicenseNumber, $customerId);
              if ($existingLicense == null){
                error_log("No license found for addon order of: " . $existingLicenseNumber);
              }
              else{
                // don't need to worry about CN upgrades through web interface yet
                switch($itemSku){
                  case 'LIB-DLA-SUB':
                    $existingLicense->setJla($existingLicense->getJla() + $_item->getQtyOrdered());
                    break;
                  case 'LIB-SLA-SUB':
                    $existingLicense->setSla($existingLicense->getSla() + $_item->getQtyOrdered());
                    break;
                  case 'LIB-SDK-SUB':
                    $existingLicense->setSdk($existingLicense->getSdk() + $_item->getQtyOrdered());
                    break;
                  case 'LIB-JMC-SUB':
                    $existingLicense->setJmc($existingLicense->getJmc() + $_item->getQtyOrdered());
                    break;
                  case 'LIB-MGL-SUB':
                    $mglBaseLine = 0;
                    if ($existingLicense->getMgl() == null || $existingLicense->getMgl() == 0){
                      // if adding MGL to a license that didn't already have it, increment by one to
                      // account for the 1 MGL that comes "free" with a base license
                      $mglBaseLine = 1;
                    }
                    $existingLicense->setMgl($existingLicense->getMgl() + $_item->getQtyOrdered() + $mglBaseLine);
                    break;
                  case 'LIB-SMS-UPGRADE':
                    // NOTE: On the order side, customer is forced to pay for all interim years
                    //       between previous maintenance date expiration and now.  At this point,
                    //       we assume that worked, and simply add 1 year to the current date or to
                    //       the existing maintenance date if it is in the future.
                    $yearTime = (365 * 24 * 60 * 60);
                    if ($existingLicense->getMaintenanceDate() == null){
                      // sanity check to baseline against purchase date
                      $existingLicense->setMaintenanceDate($existingLicense->getPurchaseDate());
                    }
                    if ($existingLicense->getMaintenanceDate() > time()){
                      // sms ends in future, add year to the end
                      $existingLicense->setMaintenanceDate($existingLicense->getMaintenanceDate() + $yearTime);
                    }
                    else{
                      // sms expired in past, new expiration 1 year from today
                      $existingLicense->setMaintenanceDate(time() + $yearTime);
                    }
                    break;
                  case 'LIB-PHONE-UPGRADE':
                    $yearTime = (365 * 24 * 60 * 60);                  
                    if ($existingLicense->getSupportDate() == null || $existingLicense->getSupportDate() < time()){
                      // sanity check to baseline against current date
                      $existingLicense->setSupportDate(time());
                    }
                    $existingLicense->setSupportDate($existingLicense->getSupportDate() + $yearTime);
                    break;
                  default:
                    error_log("Received invalid SKU in addon order: " . $itemSku);
                }
                
                $existingLicense->save();
                
                if (!array_key_exists($existingLicenseNumber, $addonMessageAdded)){
                  // add entry to license_purchase_log table so can link addons back to order#
                  try{
                    $link = Mage::getSingleton('core/resource')->getConnection('core_read');
                    $result = $link->query("INSERT INTO license_purchase_log (license_number, order_id) VALUES ('"    
                      . $existingLicenseNumber . "', '" . $order->getEntityId() . "')"); 
                  }
                  catch(Exception $sqlInsert){
                    error_log("SQL exception when inserting into license_purchase_log for " . $existingLicenseNumber);
                  }
                
                  // add message to session 
                  Mage::getSingleton('core/session')->addSuccess("License " . $existingLicenseNumber . " has been updated.  Please visit your license page and re-download it with the added upgrades.");
                  
                  // only want to do the above 1 time per order, not per item
                  $addonMessageAdded[$existingLicenseNumber] = true;
                }
              }
            }
            else{
              // we are creating new LicenseOrder entities that will be allocated
              // by the customer the next time they visit their license page.
	      $containsNewLicenses = true;
              
              switch($itemSku){
                case 'AF-PRO-02GPU-PER':
                  $licenseOrder->setBase($licenseOrder->getBase() + $_item->getQtyOrdered());
                  $licenseOrder->setQtyMgl2($licenseOrder->getQtyMgl2() + $_item->getQtyOrdered());
                  break;
                case 'AF-PRO-04GPU-PER':
                  $licenseOrder->setBase($licenseOrder->getBase() + $_item->getQtyOrdered());
                  $licenseOrder->setQtyMgl4($licenseOrder->getQtyMgl4() + $_item->getQtyOrdered());
                  break;
                case 'AF-PRO-08GPU-PER':
                  $licenseOrder->setBase($licenseOrder->getBase() + $_item->getQtyOrdered());
                  $licenseOrder->setQtyMgl8($licenseOrder->getQtyMgl8() + $_item->getQtyOrdered());
                  break;
                case 'AF-PRO-02GPU-PHONE':
                  $licenseOrder->setQtyMgl2Phone($licenseOrder->getQtyMgl2Phone() + $_item->getQtyOrdered());
                  break;
                case 'AF-PRO-04GPU-PHONE':
                  $licenseOrder->setQtyMgl4Phone($licenseOrder->getQtyMgl4Phone() + $_item->getQtyOrdered());
                  break;
                case 'AF-PRO-08GPU-PHONE':
                  $licenseOrder->setQtyMgl8Phone($licenseOrder->getQtyMgl8Phone() + $_item->getQtyOrdered());
                  break;
                default:
                  error_log("Customer purchased item they shouldn't be able to. SKU: " . $_item->getId());
                  break;
       
              }
              
            }
        }
        
        // regen the license(s) on disk
        foreach($existingLicenseNumberList as $existingNumber){
          $licenseToRegen = Mage::getModel('licenselibjacket/license')
              ->getLicenseByNumberAndCustomer($existingNumber, $customerId);
          if ($licenseToRegen != null && $licenseToRegen->getHostId() != null){
            $licenseToRegen->generateFlexLicense($licenseToRegen->getVersion());
          }
          else{
            error_log("Unable to lookup license for file regen: " . $existingNumber);
          }
        }


        if ($containsNewLicenses) {
            $licenseOrder->setPurchaseDate(time());
            if ($licenseOrder->isEmpty() == false) {
                $licenseOrder->save();
            }
        }
      }
      catch(Exception $e)
      {
        error_log('License Order Observer error:\n' . $e->getMessage());
      }
    }


    /**
     * Record the license information for each product.
     *
     * @triggeredby: sales_order_place_after
     * @param $observer array "order"=>$order
     */
    public function recordLicenseForOrderEvent($observer)
    {

        date_default_timezone_set('EST');

        $order = $observer->getEvent()->getOrder();
        $items = $order->getItemsCollection();

        $customerId = Mage::getModel('customer/session')->getCustomerId();
        $collection = Mage::getModel('customer/group')->getCollection();
        $customerGroupId = Mage::getModel('customer/session')->getCustomerGroupId();
        foreach($collection as $group)
        {
            $g = $group->toArray(array('customer_group_id', 'customer_group_code'));
            $groups[$g['customer_group_id']] = $g['customer_group_code'];
        }
        $customerGroupName = $groups[$customerGroupId];

		$customerType = 'commercial';

		if($customerGroupName=='Student'){
			$customerType = 'student';
		} elseif($customerGroupName=='Academic') {
			$customerType = 'academic';
		} elseif($customerGroupName=='Government / Research') {
			$customerType = 'government';
		}

		foreach ($items as $_item) {
            if($_item->getParentItem()) { continue;  }
			$quantity = $_item->getQtyOrdered();
			for($i=0; $i<$quantity; $i++){
				$license = Mage::getModel('licenselibjacket/license');
				$itemSku = $_item->getSku();

				$month = date('m');
				$day = date('d');
				$year = date('Y');

                $license->setMgo(1);
				$license->setMaintenanceDate(mktime(0,0,0,$month, $day, $year+1));

                try {

                    $license->setOrderNumber($order->getIncrementId());

                } catch (Exception $e) {

                    error_log('Well, that didn\'t work.');

                }

                foreach($_item->getChildrenItems() as $kid)
                {

                    $kidSku = $kid->getSku();
                    error_log('KID SKU: '.$kidSku);
                    if((substr($kidSku, 14) == 'PER') &&
                        (intval(substr($kidSku, 7, 8)) > $license->getMgo() ))
                    {

                        $license->setMgo(intval(substr($kidSku, 6, 2)));
                    }
                    if(substr($kidSku, 4, 5) == 'PHONE')
                    {

                        $license->setSupportDate(mktime(0,0,0,$month, $day,
                            $year + intval(substr($kidSku, 14, 1))));

                    }

                    if(substr($kidSku, 4, 2) == 'CN')
                    {

                        $license->setCn(1);

                    }

                    if(substr($kidSku, 6, 3) == 'SDK')
                    {

                        $license->setSdk(1);

                    }

                    if(substr($kidSku, 14, 3) == 'SMS')
                    {

                        $license->setMaintenanceDate(mktime(0,0,0,$month, $day,
                            $year * ($kid->getQty())));

                    }

                    if(substr($kidSku, 6, 3) == 'JMC')
                    {

                        $license->setJmc(1);

                    }

                }

				$license->setGfxToolbox(1);
				$license->setCustomerId($customerId);
				$license->setUserType($customerType);
				$license->setPurchaseDate(mktime(0,0,0,$month, $day, $year));
				$license->setProductSku($_item->getSku());
                $license->setPaid(1);
                $license->setLicenseCode($license->generateLicenseCode());
				$license->save();

			}
		}
	}

    public function createConcurrentNetworkLicense($data, $order, $items)
    {
      error_log("Processing CN Order:\n" . var_export($data, true));

      date_default_timezone_set('EST');

      $customerId = Mage::getModel('customer/session')->getCustomerId();
      $collection = Mage::getModel('customer/group')->getCollection();
      $customerGroupId = Mage::getModel('customer/session')->getCustomerGroupId();
      foreach($collection as $group)
      {
        $g = $group->toArray(array('customer_group_id', 'customer_group_code'));
        $groups[$g['customer_group_id']] = $g['customer_group_code'];
      }
      $customerGroupName = $groups[$customerGroupId];

      $customerType = 'commercial';

      if($customerGroupName=='Student'){
        $customerType = 'student';
      } elseif($customerGroupName=='Academic') {
        $customerType = 'academic';
      } elseif($customerGroupName=='Government / Research') {
        $customerType = 'government';
      }

      $license = Mage::getModel('licenselibjacket/license');
      $license->setData($data);

      $month = date('m');
      $day = date('d');
      $year = date('Y');

      $license->setMgo(1);

      $yearAdd = 1;
      if (isset($data['sms']) && $data['sms'] > 0) $yearAdd++;
      $license->setMaintenanceDate(mktime(0,0,0,$month, $day, $year + $yearAdd));
      if (isset($data['phone']) && $data['phone'] > 0)
        $license->setSupportDate(mktime(0,0,0, $month, $day, $year + 1));

      try {

        $license->setOrderNumber($order->getIncrementId());

      } catch (Exception $e) {

        error_log('Well, that didn\'t work. Couldn\'t set Order Number in License Observer');

      }

      $license->setCn($data['base']);
      $license->setGfxToolbox(1);
      $license->setCustomerId($customerId);
      $license->setUserType($customerType);
      $license->setPurchaseDate(mktime(0,0,0,$month, $day, $year));
      $license->setPaid(1);
      $license->setLicenseCode($license->generateLicenseCode());
      $license->save();
    }
}
