<?php
 
class Accelereyes_LicenseLibjacket_Block_Admin_New_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $customerId = $this->getRequest()->getParam('customer_id');
        $customer = Mage::getModel('customer/customer')->load($customerId);

        $form = new Varien_Data_Form();

        $fieldset = $form->addFieldset('new_license', array('legend' =>
                                                            Mage::helper('licenselibjacket')->__('License Details')));

        $featureFieldset = $form->addFieldset('new_license_feature', array('legend' => Mage::helper('licenselibjacket')->__('License Features')));

        $cnFieldset = $form->addFieldset('new_license_concurrent', array('legend' => Mage::helper('licenselibjacket')->__('Concurrent Network Specific Configuration')));

        $fieldset->addField('customer_id', 'hidden', array(
            'name'      => 'customer_id',
            'value'     => $this->getRequest()->getParam('customer_id'),
        ));

        $fieldset->addField('customer', 'text', array(
            'name'      => 'customer',
            'title'     => Mage::helper('licenselibjacket')->__('Customer'),
            'label'     => Mage::helper('licenselibjacket')->__('Customer'),
            'value'     => $customer->getName(),
            'maxlength' => '50',
            'enabled'   => false,
            'required'  => false,
        ));

        $fieldset->addField('purchase_date', 'date', array(
            'name'          => 'purchase_date',
            'title'         => Mage::helper('licenselibjacket')->__('Purchase Date'),
            'label'         => Mage::helper('licenselibjacket')->__('Purchase Date'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'      => 'true',
        ));

        $fieldset->addField('maintenance_date', 'date', array(
            'name'          => 'maintenance_date',
            'title'         => Mage::helper('licenselibjacket')->__('Maintenance/Trial Expiration'),
            'label'         => Mage::helper('licenselibjacket')->__('Maintenance/Trial Expiration'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'      => 'true',
        ));

        $fieldset->addField('support_date', 'date', array(
            'name'          => 'support_date',
            'title'         => Mage::helper('licenselibjacket')->__('Support Expiration'),
            'label'         => Mage::helper('licenselibjacket')->__('Support Expiration'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),

        ));

        $fieldset->addField('user_type', 'select', array(
            'name'          => 'user_type',
            'title'         => Mage::helper('licenselibjacket')->__('License Type'),
            'label'         => Mage::helper('licenselibjacket')->__('License Type'),
            'align'         => 'right',
            'width'         => '25',
            'options'       => $this->_getTypeArray($customerId),
            'required'      => 'true',
        ));

        $fieldset->addField('order_number', 'text', array(
            'name'          => 'order_number',
            'title'         => Mage::helper('licenselibjacket')->__('Order Number'),
            'label'         => Mage::helper('licenselibjacket')->__('Order Number'),
            'align'         => 'right',
            'maxlength'     => '50',
        ));

        $fieldset->addField('lic_qty', 'text', array(
            'name'          => 'lic_qty',
            'title'         => Mage::helper('licenselibjacket')->__('Quantity'),
            'label'         => Mage::helper('licenselibjacket')->__('Quantity'),
            'align'         => 'right',
            'maxlength'     => '3',
            'required'      => true,
            'value'         => 1,
        ));

        $fieldset->addField('expiration_date', 'date', array(
                              'name' => 'expiration_date',
                              'title' => Mage::helper('licenselibjacket')->__('Expiration Date'),
                              'label' => Mage::helper('licenselibjacket')->__('Expiration Date'),
                              'align' => 'right',
                              'image' => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
                              'format' => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
                            ));
 
        $fieldset->addField('reseller_code', 'text', array(
	    'name'          => 'reseller_code',
	    'title'	    => Mage::helper('licenselibjacket')->__('Reseller Code'),
	    'label'	    => Mage::helper('licenselibjacket')->__('Reseller Code'),
	    'style'  	    => 'width:100px'	    
	));


        $featureFieldset->addField('mgl', 'text', array(
                                     'name' => 'mgl',
                                     'title' => Mage::helper('licenselibjacket')->__('MGL'),
                                     'label' => Mage::helper('licenselibjacket')->__('MGL'),
                                     'align' => 'right',
                                     'style' => 'width:25px',
                                     'value'         => '0'
                                   ));

        $featureFieldset->addField('jla', 'text', array(
                                     'name'          => 'jla',
                                     'title'         => Mage::helper('licenselibjacket')->__('DLA'),
                                     'label'         => Mage::helper('licenselibjacket')->__('DLA'),
                                     'align'         => 'right',
                                     'style'         => 'width:25px',
                                     'value'         => '0'
                                   ));

        $featureFieldset->addField('sla', 'text', array(
                                     'name'          => 'sla',
                                     'title'         => Mage::helper('licenselibjacket')->__('SLA'),
                                     'label'         => Mage::helper('licenselibjacket')->__('SLA'),
                                     'align'         => 'right',
                                     'style'         => 'width:25px',
                                     'value'         => '0'
                                   ));

        $featureFieldset->addField('hpc', 'text', array(
                                     'name' => 'hpc',
                                     'title' => Mage::helper('licenselibjacket')->__('HPC'),
                                     'label' => Mage::helper('licenselibjacket')->__('HPC'),
                                     'align' => 'right',
                                     'style' => 'width:25px',
                                     'value' => '0'
                                   ));


        $cnFieldset->addField('cn', 'text', array(
            'name'          => 'cn',
            'title'         => Mage::helper('licenselibjacket')->__('CN Nodes'),
            'label'         => Mage::helper('licenselibjacket')->__('CN Nodes'),
            'align'         => 'right',
            'style'         => 'width:25px',
            'value'         => '0'
        ));

        $form->setMethod('post');
        $form->setUseContainer(true);
        $form->setId('edit_form');
        $form->setAction($this->getUrl('*/*/post'));
        //$form->setValues($data);
        $this->setForm($form);
    }

    protected function _getMgoArray()
    {

        $result = array();
        $result[0]= '';

        for($i=3; $i<=7; $i++) {

            $result[$i] = $i;

        }

        for($i=8; $i<=2048; $i=$i*2) {

            $result[$i] = $i;

        }

        return $result;

    }

    protected function _getTypeArray($customerId)
    {

        $result = array();

        $customer = Mage::getModel('customer/customer')->load($customerId);
        switch($customer->getGroupId())
        {
            case 1:
                $result['commercial'] = 'Individual / Commercial';
                break;
            case 3:
                $result['government'] = 'Government / Research';
                break;
            case 2:
                $result['academic'] = 'Academic';
                break;
            case 4:
                $result['student'] = 'Student';
                break;
         }

         $result['trial'] = 'Trial';
         $result['free'] = 'Free';

         return $result;

    }

    protected function _getMultiGPUTypes()
    {

        $result = array();
        $result['none'] = 'None';
        $result['mgl'] = 'MGL';
        $result['sgs'] = 'SGS';
        return $result;

    }

}
