<?php

class Accelereyes_LicenseLibjacket_Block_Admin_Main_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('licenselibjacketGrid');
        $this->setUseAjax(true);
        $this->setDefaultSort('license_number');
        $this->setDefaultDir('DESC');

    }

    protected function _prepareCollection()
    {

        $resource = Mage::getSingleton('core/resource');

        $collection = Mage::getModel('licenselibjacket/license')->getCollection()
                      ->addAttributeToFilter('user_type', 'nontrial');
        $collection->join('customer/entity', 'customer_id = entity_id');
        $collection->setPageSize(20);

        $this->setCollection($collection); 

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('license_number', array(
            'header'        => Mage::helper('license')->__('License Number'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'license_number',
            'index'         => 'license_number',
            'type'          => 'number',
        ));

        $this->addColumn('order_number', array(
            'header'        => Mage::helper('license')->__('Order Number'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'order_number',
            'index'         => 'order_number',
            'type'          => 'number',
        ));

        $this->addColumn('user_type', array(
            'header'        => Mage::helper('license')->__('User Type'),
            'align'         => 'right',
            'width'         => '50px',
            'filter'        => new Accelereyes_License_Block_Admin_Main_Grid_Filter_Type(),
            'index'         => 'user_type',
        ));

	$this->addColumn('customer_id', array(
	    'header'        => Mage::helper('license')->__('Customer ID'),
	    'index'	    => 'customer_id',
	    'filter_index'  => 'customer_id'
	));

        $this->addColumn('name', array(
            'header'        => Mage::helper('license')->__('Customer Name'),
            'index'         => 'name',
            'filter_index'  => 'entity_id',
            'filter'        => new Accelereyes_License_Block_Admin_Main_Grid_Filter_Name(),
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Name()
        ));

        $this->addColumn('email', array(
            'header'        => Mage::helper('license')->__('Customer Email'),
            'align'         => 'right',
            'width'         => '200px',
            'filter_index'  => 'email',
            'index'         => 'email',
        ));

	$this->addColumn('reseller_code', array(
	    'header'        => Mage::helper('license')->__('Reseller Code'),
	    'index'	    => 'reseller_code',
	    'filter_index'  => 'reseller_code'
	));

        $this->addColumn('purchase_date', array(
            'header'        => Mage::helper('license')->__('Purchase Date'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'purchase_date',
            'index'         => 'purchase_daterman',
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_PurchaseDate(),
        ));

        $this->addColumn('license_expiration', array(
                           'header' => Mage::helper('license')->__('License Expiration'),
                           'align' => 'right',
                           'width' => '50px',
                           'index' => 'license_expiration',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_LicenseExpiration()
                         ));

        $this->addColumn('maintenance_date', array(
            'header'        => Mage::helper('license')->__('Maintenance Expiration'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'maintenance_date',
            'index'         => 'maintenance_date',
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_MaintenanceDate(),
        ));

        $this->addColumn('support_date', array(
            'header'        => Mage::helper('license')->__('Support Expiration'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'support_date',
            'index'         => 'support_date',
            'renderer'      =>  new Accelereyes_License_Block_Admin_Main_Grid_Renderer_SupportDate(),
        ));

        $this->addColumn('mgl', array(
                           'header' => Mage::helper('license')->__('MGL'),
                           'align' => 'right',
                           'width' => '10px',
                           'index' => 'mgl',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Mgl()
                         ));

        $this->addColumn('jla', array(
                           'header'=> Mage::helper('license')->__('DLA'),
                           'align' => 'right',
                           'width' => '10px',
                           'index' => 'jla',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Jla()
                         ));

        $this->addColumn('sla', array(
                           'header'=> Mage::helper('license')->__('SLA'),
                           'align' => 'right',
                           'width' => '10px',
                           'index' => 'sla',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Sla()
                         ));

        $this->addColumn('hpc', array(
                           'header' => Mage::helper('license')->__('HPC'),
                           'align' => 'right',
                           'width' => '10px',
                           'index' => 'hpc',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Hpc()
                         ));

        $this->addColumn('cn', array(
                           'header' => Mage::helper('license')->__('CN Nodes'),
                           'align' => 'right',
                           'width' => '10px',
                           'index' => 'cn',
                           'renderer' => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Cn()
                         ));

        $this->addColumn('host_id', array(
            'header'        => Mage::helper('license')->__('Host ID'),
            'align'         => 'right',
            'width'         => '100px',
            'filter_index'  => 'host_id',
            'index'         => 'host_id',
        ));

	$this->addColumn('external_license_uuid', array(
	  'header'          => Mage::helper('license')->__('Exteral UUID'),
	  'filter_index'    => 'external_license_uuid',
	  'index'	    => 'external_license_uuid'
	));

        $this->addColumn('license_code', array(
            'header'        => Mage::helper('license')->__('License File'),
            'align'         => 'right',
            'width'         => '100px',
            //'filter_index'  => 'plp',
            //'index'         => 'license_code',
            'renderer'      => new Accelereyes_LicenseLibjacket_Block_Admin_Main_Grid_Renderer_LicenseLink(),
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('license')->__('Action'),
                'width'     => '50px',
                'type'      => 'action',
                'getter'    => 'getLicenseNumber',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('license')->__('Edit'),
                        'url'       => array(
                            'base'  => '*/*/edit'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('license')->__('Delete'),
                        'url'       => array(
                            'base'  => '*/*/delete'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('license')->__('Regenerate'),
                        'url'       => array(
                            'base'  => '*/*/regenerate'
                        ),
                        'field'     => 'id'
                    ),
                ),
                'filter'    => false,
                'sortable'  => false
            ));

        $this->addExportType('*/*/exportCsv', Mage::helper('customer')->__('CSV'));
        $this->addExportType('*/*/exportXml', Mage::helper('customer')->__('XML'));

        return parent::_prepareColumns();

    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/grid', array('_current'=>true));
    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/edit', array(
            'id' => $row->getLicenseNumber(),
        ));

    }

}
