<?php

class Accelereyes_License_AdminController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {

        if ($this->getRequest()->getQuery('ajax'))
        {
            $this->_forward('grid');
            return;
        }

        $this->loadLayout()
            ->_setActiveMenu('sales/licenses')
            ->_addContent($this->getLayout()->createBlock('license/admin_main', 'licenses'))
            ->renderLayout();

    }

    public function trialAction()
    {

        if ($this->getRequest()->getQuery('ajax'))
        {
            $this->_forward('trial_grid');
            return;
        }

        $this->loadLayout()
            ->_setActiveMenu('sales/licenses')
            ->_addContent($this->getLayout()->createBlock('license/admin_trial', 'licenses'))
            ->renderLayout();
    }

    public function gridAction()
    {
        $this->getResponse()->setBody($this->getLayout()->createBlock('license/admin_main_grid')->toHtml());
    }

    public function trial_gridAction()
    {
        $this->getResponse()->setBody($this->getLayout()->createBlock('license/admin_trial_grid')->toHtml());
    }

    public function bulkSetResellerByExternalAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_setresellerbyexternal'))
            ->renderLayout();
    }
    public function bulkSetResellerByNumberAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_setresellerbynumber'))
            ->renderLayout();
    }
    public function customerDownloadsAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_customerdownloads'))
            ->renderLayout();
    }
    public function aggregatedDownloadsAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_aggregateddownloads'))
            ->renderLayout();
    }
    public function hostChangesAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_hostchanges'))
            ->renderLayout();
    }
    public function trialAbuseAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_trialabuse'))
            ->renderLayout();
    }
    public function faqVisitsAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_faqvisits'))
            ->renderLayout();
    }
    public function activityLogAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_activitylog'))
            ->renderLayout();
    }
    public function productEventLogsAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_producteventlogs'))
            ->renderLayout();
    }
    public function manageBannedIpsAction(){
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_static_managebannedips'))
            ->renderLayout();
    }

    public function deleteAction()
    {

        $licenseId = $this->getRequest()->getParam('id',false);

        try {
            Mage::getModel('license/license')->setId($licenseId)->delete();
            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License
                        Removed Successfully'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));

            return;
        } catch (Exception $e) {
            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }

        $this->_redirectReferer();

    }

    public function newAction()
    {

        $block = $this->getLayout()->createBlock('license/admin_customer');

        $this->loadLayout()
            ->_addContent($block)
            ->renderLayout();

    }

    public function createAction()
    {

        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('license/admin_new'))
            ->renderLayout();

    }

    public function postAction()
    {
        $postProcessDestination = '*/*/';

        if ($data = $this->getRequest()->getPost()) {

            $data['purchase_date'] = strtotime($data['purchase_date']);
            $data['maintenance_date'] = strtotime($data['maintenance_date']);
            $data['support_date'] = strtotime($data['support_date']);

            if (!empty($data['expiration_date'])){
                $data['expiration_date'] = strtotime($data['expiration_date']);
            }

            if ($data['user_type']=='trial')
            {
                $data['machine_id'] = 'JUSTIN:BAILEY';
                $postProcessDestination = '*/*/trial';
            }

            if ($data['order_number'] == 0)
            {
                $data['order_number'] = null;
            }

            for($i=0; $i < (0+$data['lic_qty']); $i++) {

                $license = Mage::getModel('license/license')->setData($data);
                try {

                    $license->setLicenseCode($license->generateLicenseCode());
                    $license->setVersion(Mage::getModel('version/version')->getCurrentVersionNumber());
                    $license->save();
                    if($license->getUserType()=='trial')
                    {
                        $license->generateTrialLicense(Mage::getModel('version/version')->getCurrentVersionNumber());
                    }
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License
                            Created Successfully'));

                } catch (Exception $e) {

                    die($e->getMessage());
                    Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

                }

            }

        }

        $this->getResponse()->setRedirect($this->getUrl($postProcessDestination));

        return;

    }

    public function editAction()
    {

        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('license/admin_edit'));
        $this->renderLayout();

    }

    public function regenerateAction()
    {

        $licenseId = $this->getRequest()->getParam('id', false);
        $license = Mage::getModel('license/license')->load($licenseId);
        $license->generateFlexLicense($license->getVersion());

        Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License Regenerated Successfully'));

        $this->getResponse()->setRedirect($this->getUrl('*/*/'));

    }

    public function saveAction()
    {

        $postProcessDestination = '*/*/';

        $licenseId = $this->getRequest()->getParam('id', false);
        if($data = $this->getRequest()->getPost()) {

            $data['purchase_date'] = strtotime($data['purchase_date']);
            $data['maintenance_date'] = strtotime($data['maintenance_date']);
            $data['support_date'] = strtotime($data['support_date']);

            if (!empty($data['expiration_date'])){
                $data['expiration_date'] = strtotime($data['expiration_date']);
            }

            if ($data['user_type'] == 'trial')
            {
                $postProcessDestination = '*/*/trial/';
            }

            if ($data['order_number'] == 0)
            {
                $data['order_number'] = null;
            }

            $license = Mage::getModel('license/license')->load($licenseId)->addData($data);
            try {

                $license->setLicenseNumber($licenseId)->save();

                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License Edited Successfully'));
                $this->getResponse()->setRedirect($this->getUrl($postProcessDestination));
                return;

            } catch (Exception $e) {

                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

        }

        $this->_redirectReferer();

    }

    public function plpAction()
    {

        $licenseId = $this->getRequest()->getParam('id', false);
        $license = Mage::getModel('license/license')->load($licenseId);
        try {

            $license->generatePLP('1nduwm28dj');

            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('PLP Generated Successfully'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));
            return;

        } catch (Exception $e) {

            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

        }

        $this->_redirectReferer();

    }

    public function exportCsvAction()
    {

        $fileName   = 'jacket-licenses.csv';
        $content    = $this->getLayout()->createBlock('license/admin_main_grid')
            ->getCsv();

        $this->_prepareDownloadResponse($fileName, $content);

    }

    public function exportTrialCsvAction()
    {

        $fileName   = 'jacket-trials.csv';
        $content    = $this->getLayout()->createBlock('license/admin_trial_grid')
            ->getCsv();

        $this->_prepareDownloadResponse($fileName, $content);

    }

    public function orderAction()
    {
        $block = $this->getLayout()->createBlock('license/admin_order');

        $this->loadLayout()
            ->_addContent($block)
            ->renderLayout();
    }

    public function newOrderAction()
    { 
        $block = $this->getLayout()->createBlock('license/admin_customer');

        $this->loadLayout()
            ->_addContent($block)
            ->renderLayout();
    }

    public function createOrderAction()
    {
        $block = $this->getLayout()->createBlock('license/admin_createorder');
        $this->loadLayout()
            ->_addContent($block)
            ->renderLayout();
    }

    public function postOrderAction()
    {

        $postProcessDestination = '*/*/';

        if ($data = $this->getRequest()->getPost()) {

            $data['purchase_date'] = strtotime($data['purchase_date']);

            if ($data['order_number'] == 0)
            {
                $data['order_number'] = null;
            }

            $licenseOrder = Mage::getModel('license/order')->setData($data);
            try {

                $licenseOrder->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License Order
                            Created Successfully'));

            } catch (Exception $e) {

                die($e->getMessage());
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }


        }

        $this->getResponse()->setRedirect($this->getUrl($postProcessDestination));

        return;

    }
}
