<?php
class Accelereyes_License_Model_License extends Mage_Core_Model_Abstract
{
 
    const MAX_HOSTID_CHANGES = 3;
    const TRIAL_LENGTH_DAYS = 15;

    // default port range in flex documentation is 27000 - 27009 starting at 27000
    const DEFAULT_CN_SERVER_PORT= '27000';
  
    // keys used for encrypt/decrypt
    const REMOTE_LICENSE_TO_KEY = "5555649d-40fe-49a2-a0f3-e24acb3e7d6a";
    const REMOTE_LICENSE_FROM_KEY = "ebc39b50-b93d-4c36-a8ab-3a9720551c0d";

    protected function _construct()
    {

        $this->_init('license/license');

    }

    public function getTrialLengthDays()
    {
      return self::TRIAL_LENGTH_DAYS;
    }

    public function getMaxAllowedHostChanges($license = null)
    {
      // students only get 2 host id change before having to contact sales
      if ($license != null && !empty($license['user_type'])){
        if ($license['user_type'] == "student") return 2;
      }
      // certain abusive users limited to 2
      if ($license != null && array_key_exists("customer_id", $license)){
        $limited_customers = array("3868", "3137");
        if (in_array($license['customer_id'], $limited_customers)){
          return 2;
        }
      }

      return self::MAX_HOSTID_CHANGES;
    }    

    /**
     * Overriding the save function to ensure a uuid always gets assigned no matter how
     * the license is created.
     */
    public function save(){
      $uuid = str_replace(".", "", uniqid("", true));

      if ($this->getExternalLicenseUuid() == NULL || strlen(trim($this->getExternalLicenseUuid())) < 1){
        $this->setExternalLicenseUuid($uuid);
      }

      parent::save();
    }

    public function getDefaultServerPort()
    {
      return self::DEFAULT_CN_SERVER_PORT;
    }

    public function update($updateMachine = false)
    {
      if ($updateMachine){
        $this->setMachineUpdate($this->getMachineUpdate()+1);        
      }
      $this->save();
    }

    public function generatePLP($mpin)
    {
            if(!defined('DEBUG_THE_PLP')) { define('DEBUG_THE_PLP', true); }

            $purchaseDate = date('mdy', $this->getPurchaseDate());
            $machineId = $this->getMachineId();
            $machineId = explode(":", $machineId);
            $matlabLicense = $machineId[0];
            $matlabUser = $machineId[1];
            $type = $this->getUserType();
            $mgo = $this->getMgo();

            $IPLP = "";

            if(strlen($mpin) != 10) {
                if(DEBUG_THE_PLP) { throw new Exception('Error: Invalid Master Pin.'); }
                $JPLP = -1;
                return $JPLP;
            }
            $IPLP = $IPLP . $mpin;

            $purchaseDate = sprintf('%06g', $purchaseDate);

            if(strlen($purchaseDate) != 6) {
                if(DEBUG_THE_PLP) { throw new Exception('Error: Invalid Date.'); }
                $JPLP = -1;
                return $JPLP;
            }
            $IPLP = $IPLP . $purchaseDate;

            $lics = (string)array_sum(array_map('ord', str_split($matlabLicense)));
            $sumlic = 0;
            for ($i=0; $i<strlen($lics); $i++) {
                $sumlic = $sumlic + floatval($lics[$i]);
            }

            $elicstr = sprintf('%02g', $sumlic);
            $IPLP = $IPLP . $elicstr;

            $lenMUID = strlen($matlabUser);
            if($lenMUID < 2){
                if(DEBUG_THE_PLP) { throw new Exception('Error: Matlab User ID too small.'); }
                $JPLP = -1;
                return $JPLP;
            }
            elseif ($lenMUID < 5){
                $uid1 = $matlabUser[1];
                $uid2 = '0';
                $uid3 = '0';
            }
            elseif ($lenMUID < 7){
                $uid1 = $matlabUser[1];
                $uid2 = $matlabUser[4];
                $uid3 = '0';
            }
            elseif ($lenMUID > 6){
                $uid1 = $matlabUser[1];
                $uid2 = $matlabUser[4];
                $uid3 = $matlabUser[6];
            }

            $s1 = 0; $s2 = 0; $s3 = 0;
            $uids1 = (string)(ord($uid1)); $uids2 = (string)(ord($uid2)); $uids3 = (string)(ord($uid3));
            for($i=0; $i<strlen($uids1); $i++){
                $s1 = $s1 + floatval($uids1[$i]);
            }
            $s1 = (string)dechex($s1);
            for($i=0; $i<strlen($uids2); $i++){
                $s2 = $s2 + floatval($uids2[$i]);
            }
            $s2 = (string)dechex($s2);
            for($i=0; $i<strlen($uids3); $i++){
                $s3 = $s3 + floatval($uids3[$i]);
            }
            $s3 = (string)dechex($s3);

            if (strlen($s1) > 1){ $s1 = 'F'; }
            if (strlen($s2) > 1){ $s2 = 'F'; }
            if (strlen($s3) > 1){ $s3 = 'F'; }

            $IPLP = $IPLP . $s1 . $s2 . $s3;

            switch ((string)$type) {
            case 's':
            case 'S':
            case 'Student':
            case 'student':
                $typestr = 'A';
                break;
            case 'a':
            case 'A':
            case 'Academic':
            case 'academic':
                $typestr = 'C';
	        	break;
            case 'c':
            case 'C':
            case 'Commercial':
            case 'commercial':
                $typestr = 'D';
	        	break;
            case 'g':
            case 'G':
            case 'Government':
            case 'government':
                $typestr = 'B';
	        	break;
            case 't':
            case 'T':
            case 'Trial':
            case 'trial':
                $typestr = 'F';
	        	break;
            default:
	    		if(DEBUG_THE_PLP) { throw new Exception('Error: Incorrect type identifier: given' . $type); }
                $JPLP = -1;
                return $JPLP;
            }

            $IPLP = $IPLP . $typestr;

            $MGOstr = sprintf('%03g', $mgo);
            if (strlen($MGOstr) > 3) {
                if(DEBUG_THE_PLP) { throw new Exception('Error: MGONum exceeds maximum supported value'); }
                $JPLP = -1;
                return $JPLP;
            }
            $offset = 6;
            $d1 = floatval($MGOstr[0]) + $offset;
            $m1 = dechex($d1);

            $d2 = floatval($MGOstr[1]) + $offset;
            $m2 = dechex($d2);

            if (strlen($MGOstr) < 3) { $d3 = $offset; }
            else { $d3 = floatval($MGOstr[2]) + $offset; }
            $m3 = dechex($d3);

            $IPLP = $IPLP . $m1 . $m2 . $m3;

            $JPLP = $IPLP;

            $JPLP[0]  = $IPLP[20];
            $JPLP[1]  = $IPLP[4];
            $JPLP[2]  = $IPLP[1];
            $JPLP[3]  = $IPLP[14];
            $JPLP[4]  = $IPLP[9];

            $JPLP[5]  = $IPLP[5];
            $JPLP[6]  = $IPLP[15];
            $JPLP[7]  = $IPLP[12];
            $JPLP[8]  = $IPLP[6];
            $JPLP[9]  = $IPLP[3];

            $JPLP[10] = $IPLP[19];
            $JPLP[11] = $IPLP[23];
            $JPLP[12] = $IPLP[24];
            $JPLP[13] = $IPLP[17];
            $JPLP[14] = $IPLP[13];

            $JPLP[15] = $IPLP[21];
            $JPLP[16] = $IPLP[0];
            $JPLP[17] = $IPLP[2];
            $JPLP[18] = $IPLP[16];
            $JPLP[19] = $IPLP[22];

            $JPLP[20] = $IPLP[11];
            $JPLP[21] = $IPLP[7];
            $JPLP[22] = $IPLP[18];
            $JPLP[23] = $IPLP[8];
            $JPLP[24] = $IPLP[10];

            $JPLP = strtoupper($JPLP);

            $this->setPlp($JPLP);
            $this->save();

    }

    public function generateLicenseCode()
    {

        $len = 8;
        $base='ABCDEFGHKLMNOPQRSTWXYZabcdefghjkmnpqrstwxyz123456789';
        $max=strlen($base)-1;
        $licenseCode='';
        mt_srand((double)microtime()*1000000);
        while (strlen($licenseCode)<$len+1)
            $licenseCode.=$base{mt_rand(0,$max)};

        return $licenseCode;

    }

    public function getLicenseByNumberAndCustomer($license_number, $customerId){
      $collection = $this->getResourceCollection()
        ->addFieldToFilter("customer_id", $customerId)
          ->addFieldToFilter("license_number", $license_number);

      if ($collection != null && count($collection) == 1){
        return $collection->getFirstItem();
      }

      return null;
    }

//    enum('commercial','government','academic','student','trial','free')
    public function getCustomerPurchasedLicenses($customerId)
    {
        $collection = $this->getResourceCollection()
            ->addFieldToFilter('customer_id', $customerId)
            ->addFieldToFilter('user_type',array("in"=>array('commercial','government','academic','student')));
        return $collection;
    }

    public function getCustomerLicenses($customerId)
    {

        $collection = $this->getResourceCollection()
            ->addFieldToFilter('customer_id', $customerId);

        return $collection;

    }

    public function getCustomerConcurrentNetworkLicenses($customerId)
    {

        $collection = $this->getResourceCollection()
          ->addFieldToFilter('customer_id', $customerId);

        $concurrent = array();
        foreach($collection as $license){
          if ($license['cn'] > 0){
            $concurrent[] = $license;
          }
        }

        return $concurrent;
    }

    public function hasTrialLicense($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

                return 1;

            }

        }

        return 0;

    }

    public function hasUnexpiredTrialLicense($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

              return ($lic->getMaintenanceDate() > time()) ? 1 : 2;

            }

        }

        return 0;

    }

    public function getUnexpiredTrialLicenseNumber($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

              return ($lic->getMaintenanceDate() > time()) 
                ? $lic->getLicenseNumber() . ';' . date('F j, Y', $lic->getMaintenanceDate()) : 0;

            }

        }

        return 0;

    }

    public function getUnexpiredTrialLicense($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

              return ($lic->getMaintenanceDate() > time()) ? $lic : 0;
            }
        }
        return 0;
    }

    public function getUnexpiredTrialLicenseWithVersion($customerId,$version)
    {
    	$collection = $this->getResourceCollection()->addFieldToFilter('customer_id', $customerId);
        $bestLic = 0;


    	foreach($collection as $lic)
        {
          if ($lic->getUserType() == 'trial' && $lic->getMaintenanceDate() > time() && version_compare($version['version_number'],$lic->getVersion()) == 0)
          {
            if ($bestLic == 0 || $lic->getMaintenanceDate() > $bestLic->getMaintenanceDate())
            {
              $bestLic = $lic;
            }
          }
        }

        return $bestLic;
    }


    public function generateFlexLicense($version)
    {
      if(!$this->getCn() || $this->getCn() < 1)
      {
        $this->createDesignatedComputerLicenseTemplate($version);
      }
      else
      {
        $this->createConcurrentNetworkLicenseTemplate($version);
      }

      if (version_compare($version, "1.3") >= 0){
        $licenseFile = 'license' . $this->getLicenseCode() . '.lic';
        
        $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt13  ../license-downloads/" . $licenseFile;
        exec($cmd);	
      }
      else{
        $licenseFile = 'license' . $this->getLicenseCode() . '.lic';
        
        $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt  ../license-downloads/" . $licenseFile;
        exec($cmd);
      }
    }

    public function generateTrialLicense($version)
    {

        $this->createTrialTemplate($version);

	if (version_compare($version, "1.3") >= 0){
	  $licenseFile = 'license' . $this->getLicenseCode() . '.lic';
          $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt13 ../license-downloads/" . $licenseFile;
          exec($cmd);
	}
	else{
          $licenseFile = 'license' . $this->getLicenseCode() . '.lic';
          $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt  ../license-downloads/" . $licenseFile;
          exec($cmd);
        }


    }

    /**
     * We must run a new lmcrypt for Jacket versions 1.3+.  The new lmcrypt cannot run on the bluehost
     * server because it is missing several package dependencies.  Instead, make a request to our other
     * server and have it perform the new lmcrypt run.
     * NOTE: THIS IS NO LONGER USED, HERE FOR RECORD IN CASE EVER NEED AGAIN
     */
    public function runRemoteLmcrypt($version){
      $req = curl_init();
      curl_setopt($req, CURLOPT_URL, "http://verification.accelereyes.com/9c7ac1d2-87bb-4882-8441-5e2e57ec2555/certify_license.php");
      curl_setopt($req, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($req, CURLOPT_POST, true);

      $licenseFileName = Mage::getBaseDir() . "/license-downloads/license" . $this->getLicenseCode() . ".lic";

      $licenseHandle = fopen($licenseFileName, "r");
      $originalValue = stream_get_contents($licenseHandle);
      fclose($licenseHandle);

      $encryptedValue = $this->encrypt_license_data($originalValue, self::REMOTE_LICENSE_TO_KEY);

      $data = array(
        "original" => base64_encode($encryptedValue)
      );
      
      curl_setopt($req, CURLOPT_POSTFIELDS, $data);
      $remoteResponse = curl_exec($req);
      curl_close($req);

      $decryptedValue = $this->decrypt_license_data(base64_decode($remoteResponse), self::REMOTE_LICENSE_FROM_KEY);
      $licenseHandle = fopen($licenseFileName, "w");
      fwrite($licenseHandle, $decryptedValue);
      fclose($licenseHandle);
    }

    /**
     * Helper method for encrypting remote licensing certification requests
     */
    function encrypt_license_data($data, $key){
      $td = mcrypt_module_open('des', '', 'ecb', '');
      $key = substr($key, 0, mcrypt_enc_get_key_size($td));
      $iv_size = mcrypt_enc_get_iv_size($td);
      $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);

      mcrypt_generic_init($td, $key, $iv);
      $encryptedValue = mcrypt_generic($td, $data);

      mcrypt_generic_deinit($td);
      mcrypt_module_close($td);

      return $encryptedValue;
    }

    /**
     * Helper method for decrypting remote licensing certification requests
     */
    function decrypt_license_data($data, $key){
      $td = mcrypt_module_open('des', '', 'ecb', '');
      $key = substr($key, 0, mcrypt_enc_get_key_size($td));
      $iv_size = mcrypt_enc_get_iv_size($td);
      $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);

      mcrypt_generic_init($td, $key, $iv);
      $decryptedValue = mdecrypt_generic($td, $data);

      mcrypt_generic_deinit($td);
      mcrypt_module_close($td);

      return $decryptedValue;
    }

    public function createConcurrentNetworkLicenseTemplate($version)
    {
      $sdk = $this->getSdk();
      $mgl = $this->getMgl();
      $dla = $this->getJla();
      $sla = $this->getSla();
      $hpc = $this->getHpc(); 
      $host_name = $this->getHostName();
      $host_port = $this->getHostPort();
      $concurrent_network_nodes = $this->getCn();
      $phone = ($this->getSupportDate() == 0 ? 0 : 1);
      $expire = $this->expirationDate();

      $server_line = "SERVER " . $host_name . " " . $this->getHostId() . " " . $host_port;
      $vendor_line = "VENDOR jacket";

      $features = $this->buildFeatureLine("jacket", $version, $expire, $concurrent_network_nodes);
      if ($mgl > 0) $features .= $this->buildFeatureLine("mgl", $version, $expire, $mgl);
      if ($hpc > 0) $features .= $this->buildFeatureLine("hpc", $version, $expire, $hpc);
      if ($sdk > 0) $features .= $this->buildFeatureLine("sdk", $version, $expire, $sdk);
      if ($dla > 0) $features .= $this->buildFeatureLine("dla", $version, $expire, $dla);
      if ($sla > 0) $features .= $this->buildFeatureLine("sla", $version, $expire, $sla);

      $license_file_content =
        $server_line . "\n" .
        $vendor_line . "\n" .
        $features;

      $handle = fopen($this->licenseFilePath(), "w");

      fwrite($handle, $license_file_content);
      fclose($handle);
    }

    public function createDesignatedComputerLicenseTemplate($version)
    {
      $sdk = $this->getSdk();
      $mgl = $this->getMgl();
      $dla = $this->getJla();
      $sla = $this->getSla();
      $jmc = $this->getJmc();
      $phone = ($this->getSupportDate() == 0 ? 0 : 1);      
      $expire = $this->expirationDate();

      $features = $this->buildFeatureLine("jacket", $version, $expire, "uncounted", $this->getHostId());
      if ($mgl > 0) $features .= $this->buildFeatureLine("mgl" . ($mgl+1), $version, $expire, "uncounted", $this->getHostId());
      if ($sdk > 0) $features .= $this->buildFeatureLine("sdk", $version, $expire, "uncounted", $this->getHostId());
      if ($dla > 0) $features .= $this->buildFeatureLine("dla", $version, $expire, "uncounted", $this->getHostId());
      if ($sla > 0) $features .= $this->buildFeatureLine("sla", $version, $expire, "uncounted", $this->getHostId());
      if ($jmc > 0) $features .= $this->buildFeatureLine("jmc", $version, "permanent", "uncounted", "ANY");

      $handle = fopen($this->licenseFilePath(), "w");

      fwrite($handle, $features);
      fclose($handle);
    }

    public function createTrialTemplate($version)
    {
      $expire = strtolower(date("d-M-Y", $this->getMaintenanceDate()));

      // hard coded because this is a trial, fully loaded Designated Computer license
      $features = $this->buildFeatureLine("jacket", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("mgl16", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("dla", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("sla", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("sdk", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("jmc", $version, $expire, "uncounted", "ANY");

      $handle = fopen($this->licenseFilePath(), "w");
      fwrite($handle, $features);
      fclose($handle);
    }

    private function licenseFilePath(){
      return Mage::getBaseDir() . "/license-downloads/license" . $this->getLicenseCode() . ".lic";
    }
 
    private function expirationDate(){
      $expire = "permanent";

      if ($this->getExpirationDate() != null && $this->getExpirationDate() > 0){
        $expire = strtolower(date("d-M-Y", $this->getExpirationDate()));
      }
      else if (($this->getUserType() == "student") || ($this->getUserType() == "free")){
        $expire = strtolower(date("d-M-Y", $this->getMaintenanceDate()));
      }

      return $expire;
    }

    private function buildFeatureLine($feature, $version, $expire, $count, $hostId=""){
      if ($hostId != "ANY" && $hostId != ""){
        // node locked licenses need VDH component regardless of version
        $hostId = "VDH=" . $hostId;
      }
      else if (version_compare($version, "1.3") < 0 && $hostId != ""){
        // versions before 1.3 need VDH in all cases even for node-unlocked
        $hostId = "VDH=" . $hostId;
      }

      $version = $this->convertVersionString($version);

      $feature_line = "FEATURE " . $feature . " jacket " . $version . " " . $expire . " " . $count;
      $feature_line = ($hostId != "") ? $feature_line . " TS_OK HOSTID=" . $hostId : $feature_line;
      $feature_line .= " SIGN=0\n";

      return $feature_line;
    }

    private function convertVersionString($version){
      // from now on this should pick everything up.
      // Some examples:
      //    1.4.0 => 1.40
      //    1.4.3 => 1.40
      if (version_compare($version, "1.3.0") > 0){

          if (version_compare($version, "2.0") >=0)
          {
              if (substr_count($version,".") > 1)
                  return substr_replace($version, "", strrpos($version, "."));
              else
                  return $version;
          } else
          {
              return substr(str_replace(".","",$version), 0,2);
          }
      }

      switch($version){
        case "1.1.1": $version = "1.11"; break;
        case "1.2.1": $version = "1.21"; break;
        case "1.2.2": $version = "1.21"; break; // 1.2.2 -> 1.21 due to issue with jacket product
        case "1.3.0": $version = "1.30"; break;
      }

      return $version;
    }

}
