<?php
require_once("AbuseBlocker.php");
 
class Accelereyes_License_Model_Api extends Mage_Api_Model_Resource_Abstract
{

  private $_session;
  private $_licenseModel;  

  public function __construct()
  {
    Mage::app()->setCurrentStore('default');
    $this->_session
      = Mage::getSingleton('customer/session');
    $this->_licenseModel = Mage::getModel('license/license');
  }

  public function authenticate($user, $pass)
  {
    return $this->authenticateUser($user, $pass);
  }

  public function licenses($email, $pass, $version)
  {

    if($this->authenticateUser($email, $pass))
    {
      $websiteId = Mage::app()->getWebsite()->getId();
      $store = Mage::app()->getStore(1);
      $customer = Mage::getModel('customer/customer')->setWebsiteId($websiteId)->setStore($store);
      $cust = $customer->loadByEmail($email);
      $customerId = $cust->getId();

      $licenseNumbers = array();

      $selectedVersion = Mage::getModel('version/version')->getVersionByNumber($version, $customerId);

      $hasTrial = 0;
      $trialNumber = 0;
      $trialLic = Mage::getModel('license/license')->getUnexpiredTrialLicenseWithVersion($customerId,$selectedVersion);
      if ($trialLic != 0)
      {
          $hasTrial = ($trialLic->getMaintenanceDate() > time()) ? 1 : 2;
          $trialNumber = ($trialLic->getMaintenanceDate() > time()) ? $trialLic->getLicenseNumber() . ';' . date('F j, Y', $trialLic->getMaintenanceDate()) : 0;
      }

      $licenseNumbers[] = $hasTrial . ';' . $trialNumber;

      if ($trialLic != 0 && $trialLic->getMaintenanceDate() >= $selectedVersion->getDate())
      {
          $lic = $trialLic;
          $licData = ';';
          $licData = $licData . 'Base License';
          $licData = ($lic->getMgl()) ? $licData . ', ' . ($lic->getMgl()+1) . ' MGL' : $licData;
          $licData = ($lic->getJla()) ? $licData . ', DLA' : $licData;
          $licData = ($lic->getSla()) ? $licData . ', SLA' : $licData;
          $licData = ($lic->getSdk()) ? $licData . ', SDK' : $licData;
          $licData = ($lic->getJmc()) ? $licData . ', JMC' : $licData;
          $licData = $licData . ';';
          $licData = $licData . ';';
          $licData = $licData . ';' . $lic->getVersion();
          $licData = $licData . ';';
          $licenseNumbers[] = '' . $lic->getLicenseNumber() . $licData;
      }

      //only get the customer licenses for the given customerid
      $collection = Mage::getModel('license/license')->getCustomerLicenses($customerId);

      foreach($collection as $lic)
      {
        if(($lic->getMaintenanceDate() >= $selectedVersion->getDate()) && ($lic['user_type'] != 'trial'))
        {
    	  $maxUpdates = $this->_licenseModel->getMaxAllowedHostChanges($lic);
          $updateMaxxed = ($lic->getMachineUpdate() >= $maxUpdates) ? '0':'1';
          $hostId = $lic->getHostId() ? $lic->getHostId() : 0;
          $licData = ';';
          $licData = $licData . 'Base License';
          $licData = ($lic->getMgl()) ? $licData . ', ' . ($lic->getMgl()+1) . ' MGL' : $licData;
          $licData = ($lic->getJla()) ? $licData . ', DLA' : $licData;
          $licData = ($lic->getSla()) ? $licData . ', SLA' : $licData;
          $licData = ($lic->getSdk()) ? $licData . ', SDK' : $licData;
          $licData = ($lic->getJmc()) ? $licData . ', JMC' : $licData;
          $licData = $licData . ';' . $updateMaxxed ;
          $licData = $licData . ';' . $hostId;
          $licData = $licData . ';' . $lic->getVersion();
          $licData = $licData . ';' . $lic->getHostLabel();
          $licenseNumbers[] = '' . $lic->getLicenseNumber() . $licData;
        }
      }
      return $licenseNumbers;
    }

    return null;

  }

  public function getlicense($licenseNumber, $requestedVersion, $email, $pass)
  {
    if(!$this->authenticateUser($email, $pass)) { return null; }

    $licenseModel = Mage::getModel('license/license');
    $customerId = $this->getCustomerId($email);
    $collection = Mage::getModel('license/license')
      ->getCollection();

    $license = null;

    foreach($collection as $lic)
    {
      if(($lic->getCustomerId() == $customerId) && ($lic->getLicenseNumber() == $licenseNumber))
      {
        $license = $lic;
      }
    }

    if(is_null($license)) { return null; }

    $licenseCode = $license->getLicenseCode();
    $licenseBuffer = '';
    $filename = Mage::getBaseDir()
      . '/license-downloads/license' . $licenseCode . '.lic';

    if (!file_exists($filename) || $requestedVersion != $license->getVersion()){

      // make sure the version requested is allowed for this particular license
      $serverVersion = Mage::getModel('version/version')->getVersionByNumber($requestedVersion, $customerId);

      if ($license->getMaintenanceDate() < $serverVersion->getDate()){
        return 'false';
      }

      $currentMaxVersion = Mage::getModel('version/version')->getCurrentVersionNumber($customerId);
      if (version_compare($requestedVersion, $currentMaxVersion) > 0){
      	 $requestedVersion = $currentMaxVersion;
      }      
 
      // need to regenerate the license and file
      $license->setVersion($requestedVersion);
      $license->save();
      if ($license->getUserType() == "trial"){
        $license->generateTrialLicense($license->getVersion());
      }
      else{
        $license->generateFlexLicense($license->getVersion());
      }
    }

/////// Save download to DB /////////
$link = Mage::getSingleton('core/resource')->getConnection('core_read');

$ipAddress = "Unknown";
if (array_key_exists("REMOTE_ADDR", $_SERVER) && $_SERVER['REMOTE_ADDR'] != null){
  $ipAddress = $_SERVER['REMOTE_ADDR'];
}

$result = $link->query("INSERT INTO customer_downloads (entity_id, ip_address, version) VALUES ('" . $customerId . "', '" . $ipAddress . "', '" . $filename . "')");
/////////////////////////////////////

    if(!file_exists($filename)) { return 'false'; }
    $handle = fopen($filename, "r");
    $licenseBuffer = fread($handle, filesize($filename));

    return $licenseBuffer;
  }

  public function trialexpired($email, $pass)
  {

    if(!$this->authenticateUser($email, $pass)) { return null; }

    $licenseModel = Mage::getModel('license/license');
    $customerId = $this->getCustomerId($email);

    if($customerId)
    {
      if ($licenseModel
          ->hasTrialLicense($customerId) == 0)
      {
        return null;
      }
      else
      {
        $lics = $licenseModel->getCustomerLicenses($customerId);
        
        foreach($lics as $lic)
        {
          if($lic->getUserType() == 'trial')
          { 
            return $lic->getMaintenanceDate() > time() ? null : true;
          }
        }
      }

      return 'true';
    }
  }

  public function activatetrial($user, $pass, $version)
  {
    if(!$this->authenticateUser($user, $pass)) { return null; }

    if (AbuseBlocker::is_banned_ip($_SERVER['REMOTE_ADDR'])) return null;

    $licenseModel = Mage::getModel('license/license');

    $customerId = $this->getCustomerId($user);

    if ($licenseModel->hasTrialLicense($customerId) == 0)
    {

      $license = $licenseModel;
      $month = date('m');
      $day = date('d');
      $year = date('Y');
      $license->setGfxToolbox(1);
      $license->setMgl(16);
      $license->setJla(1);
      $license->setSla(1);
      $license->setJmc(1);
      $license->setSdk(1);
      $license->setCustomerId($customerId);
      $license->setUserType('trial');
      $pDate = mktime(0,0,0,$month, $day, $year);
      $mDate = $pDate + (15 * 86400);
      $license->setPurchaseDate($pDate);
      $license->setMaintenanceDate($mDate);
      $license->setProductSku('000');
      $license->setMachineId('JUSTIN:BAILEY');
      $licenseCode = $license->generateLicenseCode();
      $license->setLicenseCode($licenseCode);
      $license->setVersion($version);
      $license->save();

      $customer = $this->getCustomerObject($user);

      Mage::dispatchEvent('begin_trial', array(
         'license'=>$license,
	  'customer'=>$customer,
      ));

      $license->generateTrialLicense($version);

      $filename = Mage::getBaseDir()
        . '/license-downloads/license' . $licenseCode . '.lic';

      $handle = fopen($filename, "r");
      $licenseBuffer = fread($handle, filesize($filename));

      return $licenseBuffer;

    }

    return null;
  }

  /**
   * This will activate a license if it has not exceeded the machine update count allowed
   */
  public function activatelicense($licenseNumber, $email, $pass, $hostId, $hostLabel)
  {
    if(!$this->authenticateUser($email, $pass)) { return null; }

    $licenseModel = Mage::getModel('license/license');
    $customerId = $this->getCustomerId($email);
    $collection = Mage::getModel('license/license')
      ->getCollection();

    $license = null;

    foreach($collection as $lic)
    {
      if(($lic->getCustomerId() == $customerId) && ($lic->getLicenseNumber() == $licenseNumber))
      {
        $license = $lic;
      }
    }

    if (is_null($license)) { return null; } 
    
    $maxUpdates = $this->_licenseModel->getMaxAllowedHostChanges($license);    

    if ($license->getMachineUpdate() > $maxUpdates) { return null; }

    $license->setVersion(Mage::getModel('version/version')->getCurrentVersionNumber($customerId));
    if ($license->getHostId() != $hostId){
      $license->setMachineUpdate($license->getMachineUpdate() + 1);

      ////////// Log HostID Change to SalesForce and Database ///////////
      $link = Mage::getSingleton('core/resource')->getConnection('core_read');
      $link->query("INSERT INTO license_host_changes "
                 . "(license_number, customer_id, previous_value, new_value) VALUES ("
                 . "'" . $licenseNumber . "','" . $customerId
                 . "','" . $license->getHostId() . "','" . $hostId . "')");

      $eventData['email'] = $email;
      $eventData['licenseNumber'] = $licenseNumber;
      $eventData['oldId'] = $license->getHostId();
      $eventData['newId'] = $hostId;
      Mage::dispatchEvent('host_id_changed', array('eventdata' => $eventData));      
    }
    $license->setHostId($hostId);
    $license->setHostLabel($hostLabel);
    $license->save();

    if ($license->getUserType() == "trial"){
      $license->generateTrialLicense($license->getVersion());
    }
    else{
      $license->generateFlexLicense($license->getVersion());
    }

    $licenseCode = $license->getLicenseCode();
    // need to generate license code if license wasn't activated via the web
    if ($licenseCode == null){
      $licenseCode = $license->generateLicenseCode();
      $license->setLicenseCode($licenseCode);
      $license->save();
    }
    $licenseBuffer = '';
    $filename = Mage::getBaseDir()
      . '/license-downloads/license' . $licenseCode . '.lic';

    if(!file_exists($filename)) { return null; }

    return "true";
  }

  private function authenticateUser($user, $pass)
  {
    $customerId = $this->getCustomerId($user);

    if($customerId == '') { return false; }

    $link = mysql_connect('localhost', 'diveyesc_mgn01', '56SNXbLsrU');
    mysql_select_db('diveyesc_mgn01');

    /* $link = mysql_connect('localhost', 'mgn_sandbox_user','GetALife456'); */
    /* mysql_select_db('magento_sandbox'); */

    // make sure account is confirmed
    $confirmQuery = sprintf("SELECT customer_entity_varchar.value FROM customer_entity_varchar WHERE entity_id='%s' AND attribute_id='609'", $customerId);
    $confirmResult = mysql_query($confirmQuery);
    if ($confirmResult != null && mysql_num_rows($confirmResult) > 0) return false;

    $query = sprintf("SELECT customer_entity_varchar.value FROM customer_entity_varchar WHERE entity_id='%s' AND attribute_id='8'", $customerId);

    $result = mysql_query($query);

    $row = mysql_fetch_assoc($result);

    $password = '';
    foreach($row as $r)
    {
      $password = $r;
    }



    if($password == '') { return false; }
    
    $password = explode(':', $password);

    $salt = $password[1];
    $password = $password[0];

    return ($password == md5($salt . $pass)); 
  }

  private static function getCustomerId($email)
  {
    $websiteId = Mage::app()->getWebsite()->getId();
    $store = Mage::app()->getStore(1);
    $customer = Mage::getModel('customer/customer')
      ->setWebsiteId($websiteId)
      ->setStore($store);
    $cust = $customer->loadByEmail($email);
    $customerId = $cust->getId();

    return $customerId;    
  }

  private static function getCustomerObject($email)
  {
    $websiteId = Mage::app()->getWebsite()->getId();
    $store = Mage::app()->getStore(1);
    $customer = Mage::getModel('customer/customer')
      ->setWebsiteId($websiteId)
      ->setStore($store);
    $cust = $customer->loadByEmail($email);

    return $cust;
  }

}
