<?php

class Accelereyes_License_Block_Admin_Trial_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('trialGrid');
        $this->setUseAjax(true);
        $this->setDefaultSort('license_number');
        $this->setDefaultDir('DESC');

    }

    protected function _prepareCollection()
    {

        $resource = Mage::getSingleton('core/resource');

        $collection = Mage::getModel('license/license')->getCollection()
                      ->addAttributeToFilter('user_type', 'trial');
        $collection->join('customer/entity', 'customer_id = entity_id');
        $collection->setPageSize(20);

        $this->setCollection($collection);

        return parent::_prepareCollection();

    }

    protected function _prepareColumns()
    {

        $this->addColumn('license_number', array(
            'header'        => Mage::helper('license')->__('License Number'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'license_number',
            'index'         => 'license_number',
            'type'          => 'number',
        ));

	$this->addColumn('customer_id', array(
	    'header'        => Mage::helper('license')->__('Customer ID'),
	    'index'	    => 'customer_id',
	    'filter_index'  => 'customer_id'
	));

        $this->addColumn('name', array(
            'header'        => Mage::helper('license')->__('Customer Name'),
            'index'         => 'name',
            'filter_index'  => 'entity_id',
            'filter'        => new Accelereyes_License_Block_Admin_Main_Grid_Filter_Name(),
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_Name()
        ));

        $this->addColumn('email', array(
            'header'        => Mage::helper('license')->__('Customer Email'),
            'align'         => 'right',
            'width'         => '200px',
            'filter_index'  => 'email',
            'index'         => 'email',
        ));

        $this->addColumn('purchase_date', array(
            'header'        => Mage::helper('license')->__('Purchase Date'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'purchase_date',
            'index'         => 'purchase_daterman',
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_PurchaseDate(),
        ));

        $this->addColumn('maintenance_date', array(
            'header'        => Mage::helper('license')->__('Maintenance Expiration'),
            'align'         => 'right',
            'width'         => '50px',
            'filter_index'  => 'maintenance_date',
            'index'         => 'maintenance_date',
            'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_MaintenanceDate(),
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('license')->__('Action'),
                'width'     => '50px',
                'type'      => 'action',
                'getter'    => 'getLicenseNumber',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('license')->__('Edit'),
                        'url'       => array(
                            'base'  => '*/*/edit'
                        ),
                        'field'     => 'id'
                    ),
                    array(
                        'caption'   => Mage::helper('license')->__('Delete'),
                        'url'       => array(
                            'base'  => '*/*/delete'
                        ),
                        'field'     => 'id'
                    ),
                ),
                'filter'    => false,
                'sortable'  => false
            ));

        $this->addExportType('*/*/exportTrialCsv', Mage::helper('customer')->__('CSV'));
        $this->addExportType('*/*/exportXml', Mage::helper('customer')->__('XML'));

        return parent::_prepareColumns();

    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/trial_grid', array('_current'=>true));
    }

    public function getRowUrl($row)
    {

        return $this->getUrl('*/*/edit', array(
            'id' => $row->getLicenseNumber(),
        ));

    }

}
