<?php

class Accelereyes_License_Block_Admin_Order_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

  public function __construct()
  {
    parent::__construct();
    $this->setId('licenseOrderGrid');
    $this->setUseAjax(true);
    $this->setDefaultSort('id');
    $this->setDefaultDir('DESC');
  }

  protected function _prepareCollection()
  {
    $resource = Mage::getSingleton('core/resource');

    $collection = Mage::getModel('license/order')->getCollection();
    $collection->setPageSize(20);

    $this->setCollection($collection);
    return parent::_prepareCollection();
  }

  protected function _prepareColumns()
  {
    $this->addColumn('id', array(
                       'header' => Mage::helper('license')->__('License Order Id'),
                       'align' => 'right',
                       'width' => '50px',
                       'filter_index' => 'id',
                       'index' => 'id',
                       'type' => 'number',
                     ));

    $this->addColumn('order_number', array(
                       'header'        => Mage::helper('license')->__('Order Number'),
                       'align'         => 'right',
                       'width'         => '50px',
                       'filter_index'  => 'order_number',
                       'index'         => 'order_number',
                       'type'          => 'number',
                     ));

    $this->addColumn('purchase_date', array(
                       'header'        => Mage::helper('license')->__('Purchase Date'),
                       'align'         => 'right',
                       'width'         => '50px',
                       'filter_index'  => 'purchase_date',
                       'index'         => 'purchase_daterman',
                       'renderer'      => new Accelereyes_License_Block_Admin_Main_Grid_Renderer_PurchaseDate(),
                     ));

    $this->addColumn('base', array(
                       'header'        => Mage::helper('license')->__('Base'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'base',
                       'index'         => 'base',
                     ));

    $this->addColumn('jla', array(
                       'header'        => Mage::helper('license')->__('JLA'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'jla',
                       'index'         => 'jla',
                     ));

    $this->addColumn('sla', array(
                       'header'        => Mage::helper('license')->__('SLA'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'sla',
                       'index'         => 'sla',
                     ));

    $this->addColumn('sdk', array(
                       'header'        => Mage::helper('license')->__('SDK'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'sdk',
                       'index'         => 'sdk',
                     ));

    $this->addColumn('jmc', array(
                       'header'        => Mage::helper('license')->__('JMC'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'jmc',
                       'index'         => 'jmc',
                     ));

    $this->addColumn('mgl', array(
                       'header'        => Mage::helper('license')->__('MGL'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'mgl',
                       'index'         => 'mgl',
                     ));

    $this->addColumn('hpc', array(
                       'header'        => Mage::helper('license')->__('HPC'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'hpc',
                       'index'         => 'hpc',
                     ));

    $this->addColumn('allocated', array(
                       'header'        => Mage::helper('license')->__('Allocated'),
                       'align'         => 'right',
                       'width'         => '10px',
                       'filter_index'  => 'allocated',
                       'index'         => 'allocated',
    ));




    return parent::_prepareColumns();

  }

}