<?php

class Accelereyes_License_Block_Admin_Customer_Grid extends Mage_Adminhtml_Block_Widget_Grid
{

    public function __construct()
    {

        parent::__construct();
        $this->setId('customerGrid');
        $this->_controller = 'license';

    }

    protected function _prepareCollection()
    {
        $collection = Mage::getResourceModel('customer/customer_collection')
            ->addNameToSelect()
            ->addAttributeToSelect('email');

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    protected function _prepareColumns()
    {
        /*$this->addColumn('firstname', array(
            'header'    => Mage::helper('customer')->__('First Name'),
            'index'     => 'firstname'
        ));
        $this->addColumn('lastname', array(
            'header'    => Mage::helper('customer')->__('Last Name'),
            'index'     => 'lastname'
        ));*/
        $this->addColumn('name', array(
            'header'    => Mage::helper('customer')->__('Name'),
            'index'     => 'name'
        ));
        $this->addColumn('email', array(
            'header'    => Mage::helper('customer')->__('Email'),
            'width'     => '50%',
            'index'     => 'email'
        ));

        return parent::_prepareColumns();
    }

    public function getRowUrl($row)
    {

      $isLicenseOrder = (isset($_SERVER['HTTP_REFERER']) && !(strpos($_SERVER['HTTP_REFERER'], 'order') === false)) ? 1 : 0;
      $trial = (isset($_SERVER['HTTP_REFERER']) && !(strpos($_SERVER['HTTP_REFERER'], 'trial') === false)) ? 1 : 0;

      if($isLicenseOrder)
      {
        return $this->getUrl('*/*/createorder', array(
                               'customer_id'=>$row->getId(),
                               'trial'=>$trial,
                             ));
      }

      return $this->getUrl('*/*/create', array(
                             'customer_id'=>$row->getId(),
                             'trial'=>$trial,
                           ));

    }

}
