<?php

class Accelereyes_License_Block_Admin_Createorder_Form extends Mage_Adminhtml_Block_Widget_Form
{

  protected function _prepareForm()
  {

    $form = new Varien_Data_Form();

    $customerId = $this->getRequest()->getParam('customer_id');
    $customer = Mage::getModel('customer/customer')->load($customerId);

    $fieldset = $form->addFieldset('new_licenseorder', array(
                                     'legend' => Mage::helper('license')->__('License Order Details') 
                                   ));

    $fieldset->addField('customer_id', 'hidden', array(
                          'name'      => 'customer_id',
                          'value'     => $this->getRequest()->getParam('customer_id'),
                        ));

    $fieldset->addField('purchase_date', 'date', array(
                          'name'          => 'purchase_date',
                          'title'         => Mage::helper('license')->__('Purchase Date'),
                          'label'         => Mage::helper('license')->__('Purchase Date'),
                          'align'         => 'right',
                          'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN)
                          . '/adminhtml/default/default/images/grid-cal.gif',
                          'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
                          'required'      => 'true',
                        ));

    $fieldset->addField('order_number', 'text', array(
                          'name'          => 'order_number',
                          'title'         => Mage::helper('license')->__('Order Number'),
                          'label'         => Mage::helper('license')->__('Order Number'),
                          'align'         => 'right',
                          'maxlength'     => '50',
                        ));

    $fieldset->addField('base', 'text', array(
                          'name'          => 'base',
                          'title'         => Mage::helper('license')->__('Base Quantity'),
                          'label'         => Mage::helper('license')->__('Base Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 1,
                        ));

    $fieldset->addField('jla', 'text', array(
                          'name'          => 'jla',
                          'title'         => Mage::helper('license')->__('JLA Quantity'),
                          'label'         => Mage::helper('license')->__('JLA Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('sla', 'text', array(
                          'name'          => 'sla',
                          'title'         => Mage::helper('license')->__('SLA Quantity'),
                          'label'         => Mage::helper('license')->__('SLA Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('sdk', 'text', array(
                          'name'          => 'sdk',
                          'title'         => Mage::helper('license')->__('SDK Quantity'),
                          'label'         => Mage::helper('license')->__('SDK Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('jmc', 'text', array(
                          'name'          => 'jmc',
                          'title'         => Mage::helper('license')->__('JMC Quantity'),
                          'label'         => Mage::helper('license')->__('JMC Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('mgl', 'text', array(
                          'name'          => 'mgl',
                          'title'         => Mage::helper('license')->__('MGL Quantity'),
                          'label'         => Mage::helper('license')->__('MGL Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('hpc', 'text', array(
                          'name'          => 'hpc',
                          'title'         => Mage::helper('license')->__('HPC Quantity'),
                          'label'         => Mage::helper('license')->__('HPC Quantity'),
                          'align'         => 'right',
                          'maxlength'     => '5',
                          'required'      => true,
                          'value'         => 0,
                        ));

    $fieldset->addField('sms', 'checkbox', array(
                          'name'          => 'sms',
                          'title'         => Mage::helper('license')->__('Software Maintenance'),
                          'label'         => Mage::helper('license')->__('Software Maintenance'),
                          'align'         => 'right',
                          'width'         => '25',
                        ));

    $fieldset->addField('cn', 'checkbox', array(
                          'name'          => 'cn',
                          'title'         => Mage::helper('license')->__('Concurrent Network'),
                          'label'         => Mage::helper('license')->__('Concurrent Network'),
                          'align'         => 'right',
                          'width'         => '25',
                        ));

    $fieldset->addField('user_type', 'select', array(
                          'name'          => 'user_type',
                          'title'         => Mage::helper('license')->__('License Type'),
                          'label'         => Mage::helper('license')->__('License Type'),
                          'align'         => 'right',
                          'width'         => '25',
                          'options'       => $this->_getTypeArray($customerId),
                          'required'      => 'true',
                        ));

    $form->setMethod('post');
    $form->setUseContainer(true);
    $form->setId('edit_form');
    $form->setAction($this->getUrl('*/*/postOrder'));
    $this->setForm($form);

  }

  protected function _getTypeArray($customerId)
  {

    $result = array();

    $customer = Mage::getModel('customer/customer')->load($customerId);
    switch($customer->getGroupId())
    {
      case 1:
        $result['commercial'] = 'Individual / Commercial';
        break;
      case 3:
        $result['government'] = 'Government / Research';
        break;
      case 2:
        $result['academic'] = 'Academic';
        break;
      case 4:
        $result['student'] = 'Student';
        break;
    }

    $result['trial'] = 'Trial';
    $result['free'] = 'Free';

    return $result;

  }


}