
% mat files
cpufile1 = 'Mtimes_CPU.mat';
gpufile1 = 'Mtimes_Jacket_13.mat';
gpufile2 = 'Mtimes_Jacket_14RC.mat';

% load
load(cpufile1,'input_str','time_mean','time_var','time_all');
time_cpu1 = time_mean;
load(gpufile1,'input_str','time_mean','time_var','time_all');
time_gpu1 = time_mean;
load(gpufile2,'input_str','time_mean','time_var','time_all');
time_gpu2 = time_mean;

% recall sizes
Size = [10:4000];
pad = 9;

% gflops
gflops_cpu1 = [];
gflops_gpu1 = [];
gflops_gpu2 = [];

% convert times to gflops
for nn=[Size],
  ii = nn - pad;
  flops = nn*nn*nn*2*1e-9;

  flopsGB = (flops/(time_cpu1(ii)*1.0));
  gflops_cpu1(ii) = flopsGB;

  flopsGB = (flops/(time_gpu1(ii)*1.0));
  gflops_gpu1(ii) = flopsGB;

  flopsGB = (flops/(time_gpu2(ii)*1.0));
  gflops_gpu2(ii) = flopsGB;
end

% plot
figure(1); clf(1); 
hold on;
plot(Size,gflops_cpu1,'g-','Linewidth',1.5);
plot(Size,gflops_gpu1,'b-','Linewidth',1.5);
plot(Size,gflops_gpu2,'r-','Linewidth',1.5);
grid;
xlabel('Square Matrix Size, N\timesN   [-]');
ylabel('Performance   [GFlops]');
%legend('MATLAB R2009b','Jacket 1.3','Jacket 1.4','Location','SouthEast');

% save
print( gcf, '-djpeg99', '-r100', 'gflops_01.jpg' );
print( gcf, '-depsc2', '-r2400', 'gflops_01.eps' );
