% SORT (Single Precision Matrix)
% Benchmark to test CPU and GPU computations for a number of different
% cases. This file contains pre-run data.
%
% Torben Larsen, Aalborg University, Denmark. tl@es.aau.dk. 29-JAN-2010.
% http://www.accelereyes.com/wiki/index.php?title=Torbens_Corner
%
%     0.1:  29-JAN-2010   -Basic functionality.
%
 
 
%% Precomputed data
%==========================================================================

%--------------------------------------------------------------------------
% Intel Core 2 Duo 2.8GHz (Apple MacBook Pro 2009), Pre-computed data.
% Used "Better battery life" mode in System Preferences (mains connected).
%--------------------------------------------------------------------------
% CPU:      Intel Core 2 Duo 2.8GHz, 4GB RAM
% OS:       Mac OSX Snow Leopard
% MATLAB:   MATLAB Version 7.9.0.529 (R2009b)
%
Size_CPU_Core2Duo28_OSX_Battery_Msingle = [3,5,10,25,50,75,100:100:2500];

T_CPU_Core2Duo28_OSX_Battery_Msingle = ...
    [0.0162, 0.0119, 0.0175, 0.0570, 0.1989, 0.4363, 0.7698, 3.0344, ...
     6.8342, 12.1779, 18.9734, 27.3031, 37.1874, 49.1695, 62.2042, ...
     76.6432, 95.8752, 114.3075, 133.5783, 155.0280, 177.7708, ...
     202.0398, 228.2287, 255.8632, 284.8973, 317.8786, 347.9127, ...
     381.8504, 417.3364, 454.1551, 493.6792]*1E-2;


%--------------------------------------------------------------------------
% NVIDIA GeForce 9600M GT (Apple MacBook Pro 2009), Pre-computed data
%--------------------------------------------------------------------------
% CPU:      Intel Core 2 Duo 2.8GHz, 4GB RAM
% GPU:      NVIDIA GeForce 9600M GT
% OS:       Ubuntu 9.02
% MATLAB:   MATLAB Version 7.9.0.529 (R2009b)
Size_GPU_9600MGT_Ubuntu_Msingle = [3,5,10,25,50,75,100:100:2500];

T_GPU_9600MGT_Ubuntu_Msingle = ...
    [0.2737, 0.1925, 0.1978, 0.2618, 0.4566, 0.8460, 1.4128, 5.1788, ...
     11.3783, 21.9712, 31.6434, 45.2950, 61.4790, 80.2822, 102.0909, ...
     125.5829, 152.0403, 181.1362, 212.7686, 246.9741, 306.3946, ...
     323.8176, 390.9707, 410.9248, 460.0066, 507.9286, 568.2950, ...
     619.0503, 681.1202, 740.2197, 865.3510]*1E-3;


%--------------------------------------------------------------------------
% NVIDIA Tesla C1060, Pre-computed data
%--------------------------------------------------------------------------
% CPU:      Intel Core i7 975 Extreme 3.33GHz, 12GB RAM
% GPU:      NVIDIA Tesla C1060
% OS:       MicroSoft Windows 7 Enterprise x64
% MATLAB:   MATLAB Version 7.9.0.529 (R2009b)
%
Size_GPU_Tesla_W7_Msingle = [3,5,10,25,50,75,100:100:2500];

T_GPU_Tesla_W7_Msingle = ...
    [1.8486, 1.8019, 1.8646, 2.0992, 2.0880, 2.2025, 2.9302, 6.1358, ...
     11.1319, 18.5358, 28.5761, 40.3829, 54.8461, 71.7621, 91.0403, ...
     113.6265, 137.3591, 164.1657, 198.0436, 226.1339, 263.8667, ...
     303.9145, 348.0947, 389.0271, 445.5959, 489.4963, 557.9526, ...
     610.2873, 666.6072, 766.4349, 827.3965]*1E-4;


%% Plot execution times
%==========================================================================
figure(1); clf(1);
plot(Size_CPU_Core2Duo28_OSX_Battery_Msingle, ...
    T_CPU_Core2Duo28_OSX_Battery_Msingle ./ ...
    T_GPU_9600MGT_Ubuntu_Msingle, 'r-*', ...
    Size_CPU_Core2Duo28_OSX_Battery_Msingle, ...
    T_CPU_Core2Duo28_OSX_Battery_Msingle ./ ...
    T_GPU_Tesla_W7_Msingle, 'g-*',...
    'LineWidth', 2);
grid;
title('BESSELJ - Single Precision (SP), Square Matrix');
xlabel('#Rows = #Columns   [-]');
ylabel('Speed-up   [-]');
legend('9600M GT vs. Core 2 Duo 2.8GHz', 'Tesla vs. Core 2 Duo 2.8GHz', ...
    'Location', 'Best');


%% Save figure in JPEG and EPS format
print( gcf, '-depsc2', '-r200', 'BESSELJ_Joint_Msingle.eps' );
print( gcf, '-djpeg99', '-r100', 'BESSELJ_Joint_Msingle.jpg' );